<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

////////////// Fonts
////////////////////

$cat = array(
    "sans-serif" => "sans-serif",
    "serif" => "serif",
    "display" => "cursive",
    "handwriting" => "cursive",
    "monospace" => "monospace"
);

$pFontHot = json_decode(str_replace("\\","",$tparams->pFontHot),"true");
if(isset($pFontHot['googleFont']) && $pFontHot['googleFont'] == "yes")
    $pFamily = "'".$pFontHot['fontFamily']."', ".$cat[$pFontHot['categories']];
else
    $pFamily = $pFontHot['fontFamily'];

$h1FontHot = json_decode(str_replace("\\","",$tparams->h1FontHot),"true");
if(isset($h1FontHot['googleFont']) && $h1FontHot['googleFont'] == "yes")
    $h1Family = "'".$h1FontHot['fontFamily']."', ".$cat[$h1FontHot['categories']];
else
    $h1Family = $h1FontHot['fontFamily'];

$h2FontHot = json_decode(str_replace("\\","",$tparams->h2FontHot),"true");
if(isset($h2FontHot['googleFont']) && $h2FontHot['googleFont'] == "yes")
    $h2Family = "'".$h2FontHot['fontFamily']."', ".$cat[$h2FontHot['categories']];
else
    $h2Family = $h2FontHot['fontFamily'];

$h3FontHot = json_decode(str_replace("\\","",$tparams->h3FontHot),"true");
if(isset($h3FontHot['googleFont']) && $h3FontHot['googleFont'] == "yes")
    $h3Family = "'".$h3FontHot['fontFamily']."', ".$cat[$h3FontHot['categories']];
else
    $h3Family = $h3FontHot['fontFamily'];

$h4FontHot = json_decode(str_replace("\\","",$tparams->h4FontHot),"true");
if(isset($h4FontHot['googleFont']) && $h4FontHot['googleFont'] == "yes")
    $h4Family = "'".$h4FontHot['fontFamily']."', ".$cat[$h4FontHot['categories']];
else
    $h4Family = $h4FontHot['fontFamily'];

$logoFontHot = json_decode(str_replace("\\","",$tparams->logoFontHot),"true");
if(isset($logoFontHot['googleFont']) && $logoFontHot['googleFont'] == "yes")
    $logoFamily = "'".$logoFontHot['fontFamily']."', ".$cat[$logoFontHot['categories']];
else
    $logoFamily = $logoFontHot['fontFamily'];

$sloganFontHot = json_decode(str_replace("\\","",$tparams->sloganFontHot),"true");
if(isset($sloganFontHot['googleFont']) && $sloganFontHot['googleFont'] == "yes")
    $sloganFamily = "'".$sloganFontHot['fontFamily']."', ".$cat[$sloganFontHot['categories']];
else
    $sloganFamily = $sloganFontHot['fontFamily'];

////////////// Main section
///////////////////////////

$cssoutput = "/* SPARKY DYNAMICALLY GENERATED CSS - DO NOT EDIT THIS FILE!
YOUR CHANGES WILL BE OVERWRITTEN AFTER NEXT SAVE OF TEMPLATE PARAMETERS!
You can add your custom CSS code in template options, under Custom tab or
you can edit file custom.css to add your CSS code. */
";

////////////// Font Awesome
///////////////////////////

if ($tparams->loadFontAwesome) {
    $cssoutput .= "
@import url('../../sparky_framework/css/icons/fontawesome.min.css');
";
}

////////////// Colors
/////////////////////

$sparky_colors_array = [$tparams->bodyBgColor, $tparams->containerBgColor, $tparams->h1Color, $tparams->h2Color, $tparams->h3Color, $tparams->h4Color, $tparams->pColor, $tparams->linksColor, $tparams->linksHoverColor, $tparams->logoColor, $tparams->sloganColor, $tparams->topPanelButtonBgColor, $tparams->topPanelButtonTextColor, $tparams->topPanelButtonBorderColor, $tparams->topPanelBgColor, $tparams->topPanelH3Color, $tparams->topPanelTextColor, $tparams->pageTransitionBg];

foreach ($sparky_colors_array as &$color) {
    if ($color == $tparams->sparkycolor1) {
        $color = "var(--sparkycolor1)";
    }
    if ($color == $tparams->sparkycolor2) {
        $color = "var(--sparkycolor2)";
    }
    if ($color == $tparams->sparkycolor3) {
        $color = "var(--sparkycolor3)";
    }
    if ($color == $tparams->sparkycolor4) {
        $color = "var(--sparkycolor4)";
    }
    if ($color == $tparams->sparkycolor5) {
        $color = "var(--sparkycolor5)";
    }
    if ($color == $tparams->sparkycolor6) {
        $color = "var(--sparkycolor6)";
    }
}

$tparams->bodyBgColor = $sparky_colors_array[0];
$tparams->containerBgColor = $sparky_colors_array[1];
$tparams->h1Color = $sparky_colors_array[2];
$tparams->h2Color = $sparky_colors_array[3];
$tparams->h3Color = $sparky_colors_array[4];
$tparams->h4Color = $sparky_colors_array[5];
$tparams->pColor = $sparky_colors_array[6];
$tparams->linksColor = $sparky_colors_array[7];
$tparams->linksHoverColor = $sparky_colors_array[8];
$tparams->logoColor = $sparky_colors_array[9];
$tparams->sloganColor = $sparky_colors_array[10];
$tparams->topPanelButtonBgColor = $sparky_colors_array[11];
$tparams->topPanelButtonTextColor = $sparky_colors_array[12];
$tparams->topPanelButtonBorderColor = $sparky_colors_array[13];
$tparams->topPanelBgColor = $sparky_colors_array[14];
$tparams->topPanelH3Color = $sparky_colors_array[15];
$tparams->topPanelTextColor = $sparky_colors_array[16];
$tparams->pageTransitionBg = $sparky_colors_array[17];

////////////// Body
///////////////////

$cssoutput .= $pFontHot->googleFont."
* {
    box-sizing: border-box;
}

body {
    color:".$tparams->pColor.";
    font-size:".str_replace("@", "", $tparams->pSize).";
    line-height:".$tparams->pLineHeight.";
    font-family:".$pFamily;
    if (isset($pFontHot->categories)) {
        $cssoutput .= ",".$pFontHot->categories;
    }
    $cssoutput .= ";
    ";
    if ($tparams->pAlign) {
        $cssoutput .= "text-align:".$tparams->pAlign.";";
    }
    $cssoutput .= "
    font-weight:".$pFontHot['fontWeight'].";
    font-style:".$pFontHot['fontStyle'].";";
    if($tparams->bodyBgColor && ($tparams->bodyBgImageFile==-1 || $tparams->bodyBgImageFile=="")) {
        $cssoutput .= "
    background:".$tparams->bodyBgColor.";";
    }
    if($tparams->bodyBgImageFile!=-1 && $tparams->bodyBgImageFile!="") {
        $cssoutput .= "
    background:".$tparams->bodyBgColor." url('../images/".$tparams->bodyBgImageFile."') ".$tparams->bodyBgImageVerticalAlign." ".$tparams->bodyBgImageHorizontalAlign." ".$tparams->bodyBgImageRepeat;
        if($tparams->bodyBgImageFixedSwitch) {
            $cssoutput .= " fixed;";
        }else{
            $cssoutput .= ";";
        }
    }
$cssoutput .= "
}

input, textarea, button, select {
    font-family:".$pFamily;
    if (isset($pFontHot->categories)) {
        $cssoutput .= ",".$pFontHot->categories;
    }
    $cssoutput .= ";
}

.content_sparky li, dl, dd, dt {
    line-height:".$tparams->pLineHeight.";
}

.sparky_container::after {
    content:'';
    display:table;
    clear:both;
}

.clr {
    clear:both;
}

img {
    max-width: 100%;
    height: auto;
    vertical-align: middle;
    border:none;
}
";

////////////// Grid
///////////////////

$cssoutput .= "
.sparky_container {
    margin:0 auto;
    padding:0;";
    if($tparams->containerBgColor) {
        $cssoutput .= "
    background:".$tparams->containerBgColor.";";
    }
    $cssoutput .= "
}

.sparky_container > .sparky_cell {
    float:left;
}

";



$cssoutput .= "
/* GRID SYSTEM */
";

for($i = 1; $i <= $tparams->gridSystem; $i++){
    $val = $i * 100/$tparams->gridSystem;
    $cssoutput .= "
.sparkle".$i." {
    width: ".$val."%;
}
";
}

$cssoutput .= "
.full .sparky_container {
    width:100%;
}
";

////////////// Rows
///////////////////

$cssoutput .= "
/* ROW SETTINGS */
";

$module_grid = json_decode($tparams->layoutdesign);
require($_SERVER['DOCUMENT_ROOT'].JURI::root("true").DS."templates".DS."sparky_framework".DS."library".DS."sparky_grid.php");
$k = 1;
foreach($module_grid2 as $gridRow) {

    $row_background_color = $module_grid->{$gridRow[0]}->settings->p4;

    if ($row_background_color == $tparams->sparkycolor1) {
        $row_background_color = "var(--sparkycolor1)";
    }
    if ($row_background_color == $tparams->sparkycolor2) {
        $row_background_color = "var(--sparkycolor2)";
    }
    if ($row_background_color == $tparams->sparkycolor3) {
        $row_background_color = "var(--sparkycolor3)";
    }
    if ($row_background_color == $tparams->sparkycolor4) {
        $row_background_color = "var(--sparkycolor4)";
    }
    if ($row_background_color == $tparams->sparkycolor5) {
        $row_background_color = "var(--sparkycolor5)";
    }
    if ($row_background_color == $tparams->sparkycolor6) {
        $row_background_color = "var(--sparkycolor6)";
    }

    // if background
    if ($module_grid->{$gridRow[0]}->settings->p4 || $module_grid->{$gridRow[0]}->settings->p16) {
        $cssoutput .= "
.sparky_row".$k.".sparky_full {";
        // background color/image
        if ($module_grid->{$gridRow[0]}->settings->p4) {
            $cssoutput .= "
    background-color:".$row_background_color.";";
        }
        if ($module_grid->{$gridRow[0]}->settings->p16) {
            $cssoutput .= "
    background-image: url('../images/".$module_grid->{$gridRow[0]}->settings->p16."');
    background-position:".$module_grid->{$gridRow[0]}->settings->p6." ".$module_grid->{$gridRow[0]}->settings->p7.";
    background-repeat:".$module_grid->{$gridRow[0]}->settings->p8.";";
            if($module_grid->{$gridRow[0]}->settings->p9 =="1") {
                $cssoutput .= "
    background-attachment: fixed;";
            }
            if($module_grid->{$gridRow[0]}->settings->p17) {
                $cssoutput .= "
    background-size:".$module_grid->{$gridRow[0]}->settings->p17.";";
            }
        }
        $cssoutput .= "
}
";
    } // end if background

    $k++;
} // end foreach

////////////// Media queries
////////////////////////////

$templateWidthArr = explode("@", $tparams->templateWidth);
$templateWidth = $templateWidthArr[0];

if ($tparams->enableResponsive && $templateWidth > 767) {
    $cssoutput .= "

/* SCREEN < 768px AND < TEMPLATE WIDTH */

@media (max-width: 767px) {
    .sparky_container {
        width: 100%;
    }

    .sparky_container > [class*='sparkle'] {
        width: 100% !important;
    }

    .two [class*='sparkle'] {
        width: 50% !important;
    }

    .full .sparky_container {
        width:100%;
    }

    .full .sparky_container > .sparky_cell {
        margin: 0;
        padding: 0;
    }
}";

}

if ($tparams->enableResponsive && $templateWidth > 768) {
    $cssoutput .= "

/* SCREEN >= 768px AND < TEMPLATE WIDTH */

@media (min-width: 768px) {
    .sparky_container {
        width: 750px;
    }
}";

}

if ($tparams->enableResponsive && $templateWidth > 992) {
    $cssoutput .= "

/* SCREEN >= 992px AND < TEMPLATE WIDTH */

@media (min-width: 992px) {
    .sparky_container {
        width: 970px;
    }
}";

}

if ($tparams->enableResponsive && $templateWidth > 1200) {
    $cssoutput .= "

/* SCREEN >= 1200px AND < TEMPLATE WIDTH */

@media (min-width: 1200px) {
    .sparky_container {
        width: 1170px;
    }
}";

}

if ($tparams->enableResponsive) {
    $templateWidthPlus = $templateWidth + 30;
    $cssoutput .= "

/* SCREEN >= TEMPLATE WIDTH */

@media (min-width:".$templateWidthPlus."px) {";
}

$cssoutput .= "
    .sparky_container {
        width:".str_replace("@", "", $tparams->templateWidth).";
    }

    [class*='sparkle'] {
        margin-left: 0;
    }";

$cell_size = $tparams->templateWidth / $tparams->gridSystem;
$cell_size = floor($cell_size); 
$empty_no = 0;
$empty_width = ($mposition[2]*100) / $tparams->gridSystem;
$k = 1;

if ($tparams->enableResponsive) {
    $cssoutput .= "
}";
}

////////////// Non-collapsible rows
///////////////////////////////////

for($i = 1; $i <= $tparams->gridSystem; $i++){
    $val = $i * 100 / $tparams->gridSystem;
    $cssoutput .= "
.one .sparkle".$i." {
    width: ".$val."% !important;
}";

}

////////////// Fluid layout
///////////////////////////

$cssoutput .= "
.fluid .sparky_container {
    width: 100%;
}";

////////////// Gutter
/////////////////////

$cssoutput .= "
.sparky_container > .sparky_cell {
    padding:".str_replace("@", "", $tparams->cellPaddingVertical)." ".str_replace("@", "", $tparams->cellPaddingHorizontal).";
}";

////////////// Font styles
//////////////////////////

$cssoutput .= "

/* FONTS AND TYPOGRAPHY */

h1, h1 a {
    padding:30px 0;
    margin:0;
    line-height:".$tparams->h1LineHeight.";
    color:".$tparams->h1Color.";
    font-size:".str_replace("@", "", $tparams->h1Size).";
    font-family:".$h1Family;
    if (isset($h1FontHot->categories)) {
        $cssoutput .= ",".$h1FontHot->categories;
    }
    $cssoutput .= ";
    ";
    if ($tparams->h1Align) {
        $cssoutput .= "text-align:".$tparams->h1Align.";";
    }
    $cssoutput .= "
    font-weight:".$h1FontHot['fontWeight'].";
    font-style:".$h1FontHot['fontStyle'].";";
    if ($tparams->h1Underline) {
        $cssoutput .= "text-decoration:underline;";
    }
$cssoutput .= "
}
";

$cssoutput .= "
h2, h2 a {
    padding:15px 0;
    margin:0;
    line-height:".$tparams->h2LineHeight.";
    color:".$tparams->h2Color.";
    font-size:".str_replace("@", "", $tparams->h2Size).";
    font-family:".$h2Family;
    if (isset($h2FontHot->categories)) {
        $cssoutput .= ",".$h2FontHot->categories;
    }
    $cssoutput .= ";
    ";
    if ($tparams->h2Align) {
        $cssoutput .= "text-align:".$tparams->h2Align.";";
    }
    $cssoutput .= "
    font-weight:".$h2FontHot['fontWeight'].";
    font-style:".$h2FontHot['fontStyle'].";";
    if ($tparams->h2Underline) {
        $cssoutput .= "text-decoration:underline;";
    }
$cssoutput .= "
}

h2.row_heading {
    padding-left:".str_replace("@", "", $tparams->cellPaddingHorizontal).";
    padding-right:".str_replace("@", "", $tparams->cellPaddingHorizontal).";
}
";

$cssoutput .= "
h3 {
    padding:15px 0;
    margin:0;
    color:".$tparams->h3Color.";
    font-size:".str_replace("@", "", $tparams->h3Size).";
    line-height:".$tparams->h3LineHeight.";
    font-family:".$h3Family;
    if (isset($h3FontHot->categories)) {
        $cssoutput .= ",".$h3FontHot->categories;
    }
    $cssoutput .= ";
    ";
    if ($tparams->h3Align) {
        $cssoutput .= "text-align:".$tparams->h3Align.";";
    }
    $cssoutput .= "
    font-weight:".$h3FontHot['fontWeight'].";
    font-style:".$h3FontHot['fontStyle'].";";
    if ($tparams->h3Underline) {
        $cssoutput .= "text-decoration:underline;";
    }
$cssoutput .= "
}

h3.row_subheading {
    padding-left:".str_replace("@", "", $tparams->cellPaddingHorizontal).";
    padding-right:".str_replace("@", "", $tparams->cellPaddingHorizontal).";
}
";

$cssoutput .= "
h4 {
    padding:15px 0;
    margin:0;
    color:".$tparams->h4Color.";
    font-size:".str_replace("@", "", $tparams->h4Size).";
    line-height:".$tparams->h4LineHeight.";
    font-family:".$h4Family;
    if (isset($h4FontHot->categories)) {
        $cssoutput .= ",".$h4FontHot->categories;
    }
    $cssoutput .= ";
    ";
    if ($tparams->h4Align) {
        $cssoutput .= "text-align:".$tparams->h4Align.";";
    }
    $cssoutput .= "
    font-weight:".$h4FontHot['fontWeight'].";
    font-style:".$h4FontHot['fontStyle'].";";
    if ($tparams->h4Underline) {
        $cssoutput .= "text-decoration:underline;";
    }
$cssoutput .= "
}

a {
    color:".$tparams->linksColor.";
    font-weight:".$tparams->linksWeight.";
    font-style:".$tparams->linksStyle.";
    text-decoration:";
    if ($tparams->linksUnderline) {
        $cssoutput .= "underline";
    } else {
        $cssoutput .=  "none";
    }
$cssoutput .= ";
}

a:hover, a:active, a:focus {
    color:".$tparams->linksHoverColor.";
    text-decoration:";
    if ($tparams->linksUnderlineHover) {
        $cssoutput .= "underline";
    } else {
        $cssoutput .= "none";
    }
$cssoutput .= ";
}

p {
    margin: 0 0 15px;
}

button,
button.btn,
a.btn,
button.btn-primary,
p.readmore a,
a.readmore {
    display: inline-block;
    padding: 4px 12px;
    color: #333333;
    text-align: center;
    vertical-align: middle;
    background-color: #f5f5f5;
    background-image:none;
    border: 1px solid #cccccc;
    font-size:inherit;
    line-height:inherit;
    text-shadow:none;
    border-radius:0;
    box-shadow:none;
}

button:hover,
button.btn:hover,
button.btn-primary:hover,
button:active,
button.btn:active,
button.btn-primary:active,
button:focus,
button.btn:focus,
button.btn-primary:focus,
p.readmore a:hover,
p.readmore a:focus,
a.readmore:hover,
a.readmore:focus {
    color: #333333;
    text-decoration: none;
    background-color: #eeeeee;
    background-image:none;
}

p.readmore a.btn span {
    display:none;
}

/* blog layout */

.blog-items {
    display:flex;
    flex-wrap:wrap;
    justify-content:space-between;
    clear:both;
}

.blog-items.columns-2 .blog-item {
    width:calc(50% - 7.5px);
}

.blog-items.columns-3 .blog-item {
    width:calc(33.33% - 7.5px);
}

.blog-items.columns-4 .blog-item {
    width:calc(25% - 7.5px);
}

.blog-items.columns-5 .blog-item {
    width:calc(20% - 7.5px);
}

.blog-items.columns-6 .blog-item {
    width:calc(16.66% - 7.5px);
}

@media (max-width: 767px) {

    .blog-items.columns-2 .blog-item,
    .blog-items.columns-3 .blog-item,
    .blog-items.columns-4 .blog-item,
    .blog-items.columns-5 .blog-item,
    .blog-items.columns-6 .blog-item {
        width:100%;
    }

}

.page-header {
    padding: 0;
    margin: 0;
    border: 0;
}

.pull-left.item-image, figure.left.item-image {
    margin-right:15px;
    float:left;
}

.pull-right.item-image, figure.right.item-image {
    margin-left:15px;
    float:right;
}

/* forms */

form {
    margin:0;
}

.form-inline {
    display:inline;
}

#login-form input {
    padding: 4px;
}

/* lists */

ul, ol {
    margin: 15px 45px;
    padding: 0;
}

div.item-page ol li, div.item-page ul li {
    margin: 0 0 10px 0;
    padding: 0;
}

div.icons ul.dropdown-menu li {
    margin: 0;
}
";

if ($tparams->loadFontAwesome) {
    $cssoutput .= "

.fa, .fas, [class*=' icon-'], [class^=icon-] {
    font-family: 'Font Awesome 5 Free';
    font-weight: 900;
}

ul.arrow, ul.arrowleft, ul.calendar, ul.checklist, ul.clock, ul.delete, ul.email, ul.file, ul.folder, ul.heart, ul.information, ul.lock, ul.pencil, ul.play, ul.rss, ul.person, ul.shop, ul.song, ul.star, ul.star2, ul.trash, ul.tweak, ul.unlock, ul.warn {
    margin: 15px 45px;
    padding: 0;
}

ul.arrow li, ul.arrowleft li, ul.calendar li, ul.checklist li, ul.clock li, ul.delete li, ul.email li, ul.file li, ul.folder li, ul.heart li, ul.information li, ul.lock li, ul.pencil li, ul.play li, ul.rss li, ul.person li, ul.shop li, ul.song li, ul.star li, ul.star2 li, ul.trash li, ul.tweak li, ul.unlock li, ul.warn li {
    list-style: none;
    padding: 0 15px;
}

ul.arrow li:before, ul.arrowleft li:before, ul.calendar li:before, ul.checklist li:before, ul.clock li:before, ul.delete li:before, ul.email li:before, ul.file li:before, ul.folder li:before, ul.heart li:before, ul.information li:before, ul.lock li:before, ul.pencil li:before, ul.play li:before, ul.rss li:before, ul.person li:before, ul.shop li:before, ul.song li:before, ul.star li:before, ul.star2 li:before, ul.trash li:before, ul.tweak li:before, ul.unlock li:before, ul.warn li:before {
    font-family: 'Font Awesome 5 Free';
    font-weight: 900;
    padding: 0;
    margin: 0 -30px;
    position: absolute;
}

ul.arrow li:before {
    content: '\\f061';
}

ul.arrowleft li:before {
    content: '\\f060';
} 

ul.calendar li:before {
    content: '\\f073';
}

ul.checklist li:before {
    content: '\\f00c';
}

ul.clock li:before {
    content: '\\f017';
}

ul.delete li:before {
    content: '\\f00d';
}

ul.email li:before {
    content: '\\f0e0';
}

ul.file li:before {
    content: '\\f15b';
}

ul.folder li:before {
    content: '\\f07b';
}

ul.heart li:before {
    content: '\\f004';
}

ul.information li:before {
    content: '\\f05a';
}

ul.lock li:before {
    content: '\\f023';
}

ul.pencil li:before {
    content: '\\f303';
}

ul.person li:before {
    content: '\\f007';
}

ul.play li:before {
    content: '\\f04b';
}

ul.rss li:before {
    content: '\\f09e';
}

ul.shop li:before {
    content: '\\f07a';
}

ul.song li:before {
    content: '\\f001';
}

ul.star li:before {
    content: '\\f005';
}

ul.star2 li:before {
    content: '\\f006';
}

ul.trash li:before {
    content: '\\f2ed';
}

ul.tweak li:before {
    content: '\\f0ad';
}

ul.unlock li:before {
    content: '\\f09c';
}

ul.warn li:before {
    content: '\\f071';
}

/* font awesome icon sizes */

.fa-1 {
    font-size: 1em;
}

.fa-2 {
    font-size: 2em;
}

.fa-3 {
    font-size: 4em;
}

.fa-4 {
    font-size: 7em;
}

.fa-5 {
    font-size: 12em;
}

.fa-6 {
    font-size: 16em;
}

.fontawesome-icon-list {
    font-size: 10px;
}

.fontawesome-icon-list i {
    font-size: 16px;
}
";
}

$cssoutput .= "
.warning, .info, .error {
    padding:15px 30px;
    min-height: 50px;
}

.warning {
    color:#000;
    border: 1px solid #ffcc00;
    background:#ffff66;
}

.info {
    color:#006699;
    border: 1px solid #006699;
    background:#bde1ff;
}

.error {
    color:#900;
    border: 1px solid #900;
    background:#f8b5b5;
}
";

if ($tparams->loadFontAwesome) {
    $cssoutput .= "
.warning:before, .info:before, .error:before {
    font-family: 'Font Awesome 5 Free';
    font-size: 32px;
    font-weight: 900;
    line-height:1;
    margin: 0 30px 0 0;
    float: left;
}

.warning:before {
    content: '\\f071';
    color: #ffcc00;
}

.info:before {
    content: '\\f05a';
    color:#006699;
}

.error:before {
    content: '\\f057';
    color:#900;
}
";
}

$cssoutput .= "
.outline {
    background: transparent;
}

.warning.outline {
    color: #d5aa00;
}

.typewriter {
    background: url('../images/typewriter_bg.png');
    padding:20px 15px 20px 30px;
    color:#000;
    font-family:'Courier New', Courier, monospace;
    line-height:20px;
}

.quote {
    margin-left: auto;
    margin-right: auto;
    padding: 15px 15px 15px 15px;
    font-size: 24px;
    font-style: normal;
    line-height: 1.4;
    text-align: center;
    max-width: 600px;
}

.dropcap:first-letter {
    font-size: 300%;
    font-weight:bold;
    float:left;
    margin:0 10px 5px 0;
    line-height: 1;
}

.p_number:first-letter {
    display:block;
    float:left;
    font-family: monospace;
    font-size: 400%;
    line-height:1;
    font-weight:bold;
    text-align: center;
    margin:0 15px 15px 0;
    padding:5px 15px;
    position: relative;
    color: #fff;
    background: #ccc;
}

.inset_left {
    display:block;
    float:left;
    width: 150px;
    font-style: italic;
    margin: 15px 15px 15px 0;
}

.inset_right {
    display:block;
    float:right;
    width: 150px;
    font-style: italic;
    margin: 15px 0 15px 15px;
}

.inset_title {
    font-weight:bold;
    display:block;
}

img.img_left {
    float:left;
    margin:0 30px 30px 0;
}

img.img_right {
    float:right;
    margin:0 0 30px 30px;
}

blockquote {
    border-left: 3px solid #ccc;
    font-family: Georgia, serif;
    font-style: italic;
    margin: 15px;
    padding: 15px;
}

legend {
    display: block;
    padding: 15px;
    margin-bottom: 5px;
    background:#f5f5f5;
    border: 0;
    font-size:inherit;
    line-height:inherit;
}

code {
    display: block;
    padding: 1em;
    color:inherit;
    border:0;
}
";

if ($tparams->loadFontAwesome) {
    $cssoutput .= "

.quote:before {
    display: block;
    text-align: center;
    font-family: 'Font Awesome 5 Free';
    content: '\\f10d';
    font-size: 1.5em;
    font-style: normal;
    font-weight: 900;
    color: #ccc;
    float: none;
    margin-bottom: 15px;
}

.fontawesome-icon-list div {
    width: 25%;
    float: left;
    padding: 5px 0;
}

.fontawesome-icon-list i {
    width: 30px;
    color: #333;
}
";
}

////////////// CSS3 Columns
///////////////////////////

$cssoutput .= "
@media(min-width:600px) {
    .two-cols {
        -moz-column-count:2;
        -webkit-column-count:2;
        column-count:2;
        -moz-column-gap:3em;
        -webkit-column-gap:3em;
        column-gap:3em;
    }

    .three-cols {
        -moz-column-count:3;
        -webkit-column-count:3;
        column-count:3;
        -moz-column-gap:3em;
        -webkit-column-gap:3em;
        column-gap:3em;
    }

    .four-cols {
        -moz-column-count:4;
        -webkit-column-count:4;
        column-count:4;
        -moz-column-gap:3em;
        -webkit-column-gap:3em;
        column-gap:3em;
    }

    .five-cols {
        -moz-column-count:5;
        -webkit-column-count:5;
        column-count:5;
        -moz-column-gap:2em;
        -webkit-column-gap:2em;
        column-gap:2em;
    }

    .six-cols {
        -moz-column-count:6;
        -webkit-column-count:6;
        column-count:6;
        -moz-column-gap:2em;
        -webkit-column-gap:2em;
        column-gap:2em;
    }
}
";

////////////// Above/below content modules
//////////////////////////////////////////

$cssoutput .= "
.abovecontent {
    padding: 0 0 30px 0;
}

.belowcontent {
    padding: 30px 0 0 0;
}
";

////////////// Logo/slogan
//////////////////////////

$cssoutput .= "

/* LOGO */

.sparky_logo {
    color:".$tparams->logoColor.";
    font-size:".str_replace("@", "", $tparams->logoSize).";
    font-family:".$logoFamily;
    if (isset($logoFontHot->categories)) {
        $cssoutput .= ",".$logoFontHot->categories;
    }
    $cssoutput .= ";
    font-weight:".$logoFontHot['fontWeight'].";
    font-style:".$logoFontHot['fontStyle'].";
    ";
    if ($tparams->logoAlign) {
        $cssoutput .= "text-align:".$tparams->logoAlign.";";
    }
    $cssoutput .= "
    text-decoration:none;
}";

$cssoutput .= "
.sparky_slogan {
    color:".$tparams->sloganColor.";
    font-size:".str_replace("@", "", $tparams->sloganSize).";
    font-family:".$sloganFamily;
    if (isset($sloganFontHot->categories)) {
        $cssoutput .= ",".$sloganFontHot->categories;
    }
    $cssoutput .= ";
    font-weight:".$sloganFontHot['fontWeight'].";
    font-style:".$sloganFontHot['fontStyle'].";
    ";
    if ($tparams->sloganAlign) {
        $cssoutput .= "text-align:".$tparams->sloganAlign.";";
    }
    $cssoutput .= "
    text-decoration:none;
}

.sparky_logo_link {
    display:block;
}
";

////////////// Menus preparation
////////////////////////////////

// Use this function to add font overrides in menus
function cssselector($before, $menu_name, $copies, $next){
    $output  = $before.$menu_name." ".$next.(sizeof($copies) == 0 ? ""  : ", ");
    for($i=0; $i < sizeof($copies); $i++){
        $output .= $before.$copies[$i]." ".$next.($i+1 == sizeof($copies) ? "" : ", ");
    }
    return $output;
}

// Font overrides array
$cat = array(
    "sans-serif" => "sans-serif",
    "serif" => "serif",
    "display" => "cursive",
    "handwriting" => "cursive",
    "monospace" => "monospace"
);

////////////// Menus rendering
//////////////////////////////

foreach($mnucfg as $menu_name => $menu) {

    // decode JSON data for Menus font family, weight and style

    if(isset($menu['font_family_hotfont'])){
        $obj = json_decode(str_replace("\\","",$menu['font_family_hotfont']), true);
        if (isset($obj['googleFont'])) {
            if($obj['googleFont'] == "yes") {
                $menu['font_family'] = "'".$obj['fontFamily']."', ".$cat[$obj['categories']];
            } else {
                $menu['font_family'] = $obj['fontFamily'];
            }
        }
        $menu['font_weight'] = $obj['fontWeight'];
        $menu['font_style'] = $obj['fontStyle'];
    }

    if(isset($menu['font_family_sub_hotfont'])){
        $obj2 = json_decode(str_replace("\\","",$menu['font_family_sub_hotfont']), true);
        if (isset($obj2['googleFont'])) {
            if($obj2['googleFont'] == "yes") {
                $menu['font_family_sub'] = "'".$obj2['fontFamily']."', ".$cat[$obj2['categories']];
            } else {
                $menu['font_family_sub'] = $obj2['fontFamily'];
            }
        }
        $menu['font_weight_sub'] = $obj2['fontWeight'];
        $menu['font_style_sub'] = $obj2['fontStyle'];
    }

    if(isset($menu['font_family_sub_sub_hotfont'])){
        $obj3 = json_decode(str_replace("\\","",$menu['font_family_sub_sub_hotfont']), true);
        if (isset($obj3['googleFont'])) {
            if($obj3['googleFont'] == "yes") {
                $menu['font_family_sub_sub'] = "'".$obj3['fontFamily']."', ".$cat[$obj3['categories']];
            } else {
                $menu['font_family_sub_sub'] = $obj3['fontFamily'];
            }
        }
        $menu['font_weight_sub_sub'] = $obj3['fontWeight'];
        $menu['font_style_sub_sub'] = $obj3['fontStyle'];
    }

    ////////////// Standard menu
    if ($menu['type'] == "standard") {

        // colors

        $standard_colors_array = [$menu['text_color'], $menu['links_hover_color'], $menu['text_color_sub'], $menu['links_hover_color_sub']];

        foreach ($standard_colors_array as &$color) {
            if ($color == $tparams->sparkycolor1) {
                $color = "var(--sparkycolor1)";
            }
            if ($color == $tparams->sparkycolor2) {
                $color = "var(--sparkycolor2)";
            }
            if ($color == $tparams->sparkycolor3) {
                $color = "var(--sparkycolor3)";
            }
            if ($color == $tparams->sparkycolor4) {
                $color = "var(--sparkycolor4)";
            }
            if ($color == $tparams->sparkycolor5) {
                $color = "var(--sparkycolor5)";
            }
            if ($color == $tparams->sparkycolor6) {
                $color = "var(--sparkycolor6)";
            }
        }

        $menu['text_color'] = $standard_colors_array[0];
        $menu['links_hover_color'] = $standard_colors_array[1];
        $menu['text_color_sub'] = $standard_colors_array[2];
        $menu['links_hover_color_sub'] = $standard_colors_array[3];

        $cssoutput .= "

/* STANDARD MENU */
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],"");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name;
        }
        $cssoutput .= " {
    display:block;
    margin:0;
    padding:0;";
    if ($menu['text_align']) {
        $cssoutput .= "
    text-align:".$menu['text_align'].";";
    }
$cssoutput .= "
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],"ul");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." ul";
        }
        $cssoutput .= " {
    margin:".$menu['margin_sub'].$menu['margin_sub_unit'].";
    padding:0;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li";
        }
        $cssoutput .= " {
    display:block;
}
";

        if ($menu['direction'] == "horizontal") {
            if (isset($menu_copies[$menu_name])) {
                $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li");
            } else {
                $cssoutput .= "
.mnu_".$menu_name." > li";
            }
            $cssoutput .= " {
    display:inline-block;
}
";
        }

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li";
        }
        $cssoutput .= " {
    margin-bottom:".$menu['bottom_margin'].$menu['bottom_margin_unit'].";
    padding:".$menu['vertical_padding'].$menu['vertical_padding_unit']." ".$menu['horizontal_padding'].$menu['horizontal_padding_unit'].";
    font-size:".$menu['font_size'].$menu['font_size_unit'].";
    font-weight:".$menu['font_weight'].";
    font-style:".$menu['font_style'].";";
    if ($menu['text_align']) {
        $cssoutput .= "
    text-align:".$menu['text_align'].";";
    }
        $cssoutput .= "
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li > a");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li > a";
        }
        $cssoutput .= " {
    color:".$menu['text_color'].";
    font-family:".$menu['font_family'].";
    font-weight:".$menu['font_weight'].";
    font-style:".$menu['font_style'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li > a:hover");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li > a:hover";
        }
        $cssoutput .= " {
    color:".$menu['links_hover_color'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li li");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li li";
        }
        $cssoutput .= " {
    margin:0;
    padding:0;
    font-size:".$menu['font_size_sub'].$menu['font_size_sub_unit'].";
    line-height:".$menu['subitem_height'].$menu['subitem_height_unit'].";
    font-weight:".$menu['font_weight'].";
    font-style:".$menu['font_style'].";";
    if ($menu['text_align']) {
        $cssoutput .= "
    text-align:".$menu['text_align'].";";
    }
        $cssoutput .= "
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li li a");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li li a";
        }
        $cssoutput .= " {
    color:".$menu['text_color_sub'].";
    font-family:".$menu['font_family_sub'].";
    font-weight:".$menu['font_weight'].";
    font-style:".$menu['font_style'].";";
    if ($menu['text_align']) {
        $cssoutput .= "
    text-align:".$menu['text_align'].";";
    }
        $cssoutput .= "
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li li a:hover");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li li a:hover";
        }
        $cssoutput .= " {
    color:".$menu['links_hover_color_sub'].";   
}
";

    } elseif ($menu['type'] == "acc") {

        // colors

        $acc_colors_array = [$menu['text_color'], $menu['links_hover_color'], $menu['text_color_sub'], $menu['links_hover_color_sub'], $menu['accordion_pane_bg'], $menu['accordion_pane_border_color']];

        foreach ($acc_colors_array as &$color) {
            if ($color == $tparams->sparkycolor1) {
                $color = "var(--sparkycolor1)";
            }
            if ($color == $tparams->sparkycolor2) {
                $color = "var(--sparkycolor2)";
            }
            if ($color == $tparams->sparkycolor3) {
                $color = "var(--sparkycolor3)";
            }
            if ($color == $tparams->sparkycolor4) {
                $color = "var(--sparkycolor4)";
            }
            if ($color == $tparams->sparkycolor5) {
                $color = "var(--sparkycolor5)";
            }
            if ($color == $tparams->sparkycolor6) {
                $color = "var(--sparkycolor6)";
            }
        }

        $menu['text_color'] = $acc_colors_array[0];
        $menu['links_hover_color'] = $acc_colors_array[1];
        $menu['text_color_sub'] = $acc_colors_array[2];
        $menu['links_hover_color_sub'] = $acc_colors_array[3];
        $menu['accordion_pane_bg'] = $acc_colors_array[4];
        $menu['accordion_pane_border_color'] = $acc_colors_array[5];

        $cssoutput .= "

/* ACCORDION MENU */

ul.acc_sparky {
    display:block;
    margin:0;
    padding:0;
}

ul.acc_sparky li.nav-item {
    display:block !important;
    padding: 5px 15px;
}

.acc_sparky ul {
    margin-top:0 !important;
}

.acc_sparky li a {
    display:block !important;
    margin:0 !important;
    text-decoration:none;
    outline: none;
}

.acc_sparky > li > a {
    margin:0 !important;
}

.acc_sparky > li > ul {
    width:100% !important;
}

.acc_sparky > li > ul {
    position:static !important;
}

.acc_sparky > li > ul > li ul {
    position:absolute !important;
    z-index:10000;
} 

.acc_sparky .ui-icon {
    display:none !important; 
}

.acc_sparky ul {
    border:none;
}

.acc_sparky li, .acc_sparky li li ul  {
    padding:5px 10px;
    margin-bottom:0;
}

.acc_sparky > li {
    margin-bottom:3px;
}

.acc_sparky > li > ul {
    margin:0 !important;
    padding:7px 0 !important;
}

.acc_sparky li li {
    border:none;
    padding:5px 10px;
}

.acc_sparky li a {
    border:none;
    background:none;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"ul");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." ul";
        }
        $cssoutput .= " {
    background:".$menu['accordion_pane_bg'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li";
        }
        $cssoutput .= " {
    border:".$menu['accordion_pane_border_size']."px solid ".$menu['accordion_pane_border_color'].";
    border-radius:".$menu['accordion_pane_border_radius']."px;
    background:".$menu['accordion_pane_bg'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li li ul");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li li ul";
        }
        $cssoutput .= " {
    border:".$menu['accordion_pane_border_size']."px solid ".$menu['accordion_pane_border_color'].";
    border-radius:".$menu['accordion_pane_border_radius']."px;
    background:".$menu['accordion_pane_bg'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li a");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li a";
        }
        $cssoutput .= " {
    font-family:".$menu['font_family'].";
    font-size:".$menu['font_size'].$menu['font_size_unit'].";
    color:".$menu['text_color'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li a:hover");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li a:hover";
        }
        $cssoutput .= " {
    color:".$menu['links_hover_color']." !important;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li ul li a");
        } else {
    $cssoutput .= "
.mnu_".$menu_name." li ul li a";
        }
        $cssoutput .= " {
    color:".$menu['text_color_sub'].";
    font-size:".$menu['font_size_sub'].$menu['font_size_sub_unit'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li ul li a:hover");
        } else {
    $cssoutput .= "
.mnu_".$menu_name." li ul li a:hover";
        }
        $cssoutput .= " {
    color:".$menu['links_hover_color_sub']." !important;
}
";

    } elseif ($menu['type'] == "navv") {

        // colors

        $navv_colors_array = [$menu['text_color'], $menu['active_text_color'], $menu['links_hover_color'], $menu['text_color_sub'], $menu['links_hover_color_sub'], $menu['button_bg'], $menu['active_button_bg'], $menu['button_hover_bg'], $menu['drop_down_pane_bg'], $menu['drop_down_hover_bg'], $menu['border_color_first_lvl'], $menu['border_color_sub_lvl']];

        foreach ($navv_colors_array as &$color) {
            if ($color == $tparams->sparkycolor1) {
                $color = "var(--sparkycolor1)";
            }
            if ($color == $tparams->sparkycolor2) {
                $color = "var(--sparkycolor2)";
            }
            if ($color == $tparams->sparkycolor3) {
                $color = "var(--sparkycolor3)";
            }
            if ($color == $tparams->sparkycolor4) {
                $color = "var(--sparkycolor4)";
            }
            if ($color == $tparams->sparkycolor5) {
                $color = "var(--sparkycolor5)";
            }
            if ($color == $tparams->sparkycolor6) {
                $color = "var(--sparkycolor6)";
            }
        }

        $menu['text_color'] = $navv_colors_array[0];
        $menu['active_text_color'] = $navv_colors_array[1];
        $menu['links_hover_color'] = $navv_colors_array[2];
        $menu['text_color_sub'] = $navv_colors_array[3];
        $menu['links_hover_color_sub'] = $navv_colors_array[4];
        $menu['button_bg'] = $navv_colors_array[5];
        $menu['active_button_bg'] = $navv_colors_array[6];
        $menu['button_hover_bg'] = $navv_colors_array[7];
        $menu['drop_down_pane_bg'] = $navv_colors_array[8];
        $menu['drop_down_hover_bg'] = $navv_colors_array[9];
        $menu['border_color_first_lvl'] = $navv_colors_array[10];
        $menu['border_color_sub_lvl'] = $navv_colors_array[11];

        $cssoutput .= "

/* DROP-DOWN MENU */
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],"");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name;
        }
        $cssoutput .= " {
    display:block;
    margin:0;
    padding:0;
    list-style-type:none;
    list-style-position:outside;
    position:absolute;
    z-index:100;
    white-space:nowrap;";
    if ($menu['drop_down_alignment']) {
        $cssoutput .= "
    text-align:".$menu['drop_down_alignment'].";";
    }
    $cssoutput .= "
    position:relative;
    font-family:".$menu['font_family'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .= 
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"ul");
        } else {
    $cssoutput .= "
.mnu_".$menu_name." ul";
        }
        $cssoutput .= " {
    margin:0;
    list-style-type:none;
    list-style-position:outside;
    text-align:initial;
    position:absolute;
    z-index:100;";
        if ($menu['drop_down_pane_bg']) {
            $cssoutput .= "
    background:".$menu['drop_down_pane_bg'].";";
        }
        $cssoutput .= "
    width:".$menu['drop_down_pane_width'].$menu['drop_down_pane_width_unit'].";
    border:".$menu['border_size_sub_lvl']."px solid ".$menu['border_color_sub_lvl'].";
    padding:".$menu['drop_down_pane_padding'].$menu['drop_down_pane_padding_unit'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .= 
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li > a").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li > span");
        } else {
    $cssoutput .= "
.mnu_".$menu_name." > li > a, .mnu_".$menu_name." > li > span";
        }
        $cssoutput .= " {
    display:block;
    margin:0;
    text-decoration:none;
    color:".$menu['text_color'].";
    font-size:".$menu['font_size'].$menu['font_size_unit'].";
    padding:0 ".$menu['drop_down_button_horiz_padding'].$menu['drop_down_button_horiz_padding_unit'].";
    font-weight:".$menu['font_weight'].";
    font-style:".$menu['font_style'].";
    height:".$menu['drop_down_button_height'].$menu['drop_down_button_height_unit'].";
    line-height:".$menu['drop_down_button_height'].$menu['drop_down_button_height_unit'].";
    cursor:pointer;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .= 
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li.active > a").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li.active > span");
        } else {
    $cssoutput .= "
.mnu_".$menu_name."  > li.active > a, .mnu_".$menu_name." > li.active > span";
        }
        $cssoutput .= " {
    color:".$menu['active_text_color'].";
    cursor:pointer;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li > a:hover").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li:hover > a").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li > a:hover").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li:hover > span");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li > a:hover, .mnu_".$menu_name." > li:hover > a, .mnu_".$menu_name." > li > a:hover, .mnu_".$menu_name." > li:hover > span";
        }
        $cssoutput .= " {
    color:".$menu['links_hover_color'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li";
        }
        $cssoutput .= " {
    display:inline-block;
    position:relative;";
        if ($menu['drop_down_button_width']) {
            $cssoutput .= "
    width:".$menu['drop_down_button_width'].$menu['drop_down_button_width_unit'].";";
        }
    if ($menu['text_align']) {
        $cssoutput .= "
    text-align:".$menu['text_align'].";";
    } 
        $cssoutput .= "
    margin:0;
    padding:0;";
            $cssoutput .= "
    border-right:".$menu['border_size_first_lvl']."px solid ".$menu['border_color_first_lvl'].";";
        $cssoutput .= "
    border-bottom:".$menu['border_size_first_lvl']."px solid ".$menu['border_color_first_lvl'].";
    border-top:".$menu['border_size_first_lvl']."px solid ".$menu['border_color_first_lvl'].";";
        if ($menu['button_bg']) {
            $cssoutput .= "
    background:".$menu['button_bg'].";";
        }
        $cssoutput .= "
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li.active");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li.active";
        }
        $cssoutput .= " {";
        if ($menu['active_button_bg']) {
            $cssoutput .= "
    background:".$menu['active_button_bg'].";";
        }
        $cssoutput .= "
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li:first-child");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li:first-child";
        }
        $cssoutput .= " {";
            $cssoutput .= "
    border-left:".$menu['border_size_first_lvl']."px solid ".$menu['border_color_first_lvl'].";";
        $cssoutput .= "
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li:hover");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li:hover";
        }
        $cssoutput .= " {
    position:relative;";
        if ($menu['button_hover_bg']) {
            $cssoutput .= "
    background:".$menu['button_hover_bg'].";";
        }
        $cssoutput .= "
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li ul li:hover");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li ul li:hover";
        }
        $cssoutput .= " {";
        if ($menu['drop_down_hover_bg']) {
            $cssoutput .= "
    background-color:".$menu['drop_down_hover_bg'].";";
        }
        $cssoutput .= "
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li ul li");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li ul li";
        }
        $cssoutput .= " {
    height:".$menu['drop_down_pane_height'].$menu['drop_down_pane_height_unit'].";
    border-bottom:".$menu['border_size_sub_lvl']."px solid ".$menu['border_color_sub_lvl'].";
    padding:0 ".$menu['drop_down_pane_horiz_padding'].$menu['drop_down_pane_horiz_padding_unit'].";
    margin: 0;
    ";
    if ($menu['text_align']) {
        $cssoutput .= "
    text-align:".$menu['text_align'].";";
    } 
        $cssoutput .= "
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li ul a").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li ul span");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li ul a, .mnu_".$menu_name." li ul span";
        }
        $cssoutput .= " {
    display: block;
    line-height:".$menu['drop_down_pane_height'].$menu['drop_down_pane_height_unit'].";
    font-size:".$menu['font_size_sub'].$menu['font_size_sub_unit'].";
    color:".$menu['text_color_sub'].";
    font-weight:".$menu['font_weight_sub'].";
    font-family:".$menu['font_family_sub'].";
    font-style:".$menu['font_style_sub'].";
    padding-top:0;
    cursor:pointer;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li ul li:hover > a").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li ul li:hover > span");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li ul li:hover > a, .mnu_".$menu_name." li ul li:hover > span";
        }
        $cssoutput .= " {
    color:".$menu['links_hover_color_sub'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name]," li ul ul");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li ul ul";
        }
        $cssoutput .= " {";
            $cssoutput .= "
    left: calc(".$menu['drop_down_pane_width'].$menu['drop_down_pane_width_unit']." - ".$menu['drop_down_pane_padding'].$menu['drop_down_pane_padding_unit'].");";
        $cssoutput .= "
    margin-top:-".$menu['drop_down_pane_padding'].$menu['drop_down_pane_padding_unit'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"ul ul");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." ul ul";
        }
        $cssoutput .= " {
    top:0px;
}
";

        if($menu['arrows']) {

            if (isset($menu_copies[$menu_name])) {
                $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li.parent");
            } else {
                $cssoutput .= "
.mnu_".$menu_name." > li.parent";
            }
            $cssoutput .= " {
    background-image:url('../images/arrow_down.png');
    background-repeat:no-repeat;";
                $cssoutput .= "
    background-position:right center;
    padding-right:15px;";
            $cssoutput .= "
}
";

            if (isset($menu_copies[$menu_name])) {
                $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li li.parent");
            } else {
                $cssoutput .= "
.mnu_".$menu_name." li li.parent";
            }
            $cssoutput .= " {";
                $cssoutput .= "
    background:url('../images/arrow_right.png') no-repeat right center;";
            $cssoutput .= "
}
";
        }

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],".sub");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." .sub";
        }
        $cssoutput .= " {
    font-size:10px;
    line-height:normal;
    display:block;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li > ul");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li > ul";
        }
        $cssoutput .= " {
    display: none;
}
";

    } elseif ($menu['type'] == "navh") {

        $cssoutput .= "

/* HORIZONTAL MENU */
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"");
        } else {
            $cssoutput .= "
.mnu_".$menu_name;
        }
        $cssoutput .= " {";
        if ($menu['tab_color']) {
            $cssoutput .= "
    display:block;
    background:".$menu['tab_color'].";";
        }
        $cssoutput .= "
    width:100%;
    height:".$menu['tab_height'].$menu['tab_height_unit'].";
    font-family:".$menu['font_family'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li";
        }
        $cssoutput .= " {";
        if ($menu['button_bg']) {
            $cssoutput .= " 
    background:".$menu['button_bg'].";";
        }
        $cssoutput .= "
    line-height:".$menu['tab_height'].$menu['tab_height_unit'].";
    padding:0 ".$menu['horiz_button_padding'].$menu['horiz_button_padding_unit'].";
    margin:0;
    border:".$menu['border_size_first_lvl']."px solid ".$menu['border_color_first_lvl'].";";
        if (!$menu['margin_size']) {
            $cssoutput .= "
    border-left:none;";
        }
        $cssoutput .= "
    border-bottom:none;
    margin:0 ".$menu['margin_size'].$menu['margin_size_unit'].";
    border-radius:".$menu['border_radius']."px ".$menu['border_radius']."px 0 0;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li:first-child");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li:first-child";
        }
        $cssoutput .= " {
    border-left:".$menu['border_size_first_lvl']."px solid ".$menu['border_color_first_lvl'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li:hover").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li.parent:hover").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li.active_tab");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li:hover, .mnu_".$menu_name." > li.parent:hover, .mnu_".$menu_name." > li.active_tab";
        }
        $cssoutput .= " {";
        if ($menu['button_hover_bg']) {
            $cssoutput .= "
    background:".$menu['button_hover_bg'].";";
        }
        $cssoutput .= "
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li.active");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li.active";
        }
        $cssoutput .= " {";
        if ($menu['active_button_bg']) {
            $cssoutput .= "
    background:".$menu['active_button_bg'].";";
        }
        $cssoutput .= "
    border-color:".$menu['border_color_active'].";
    border-left:".$menu['border_size_first_lvl']."px solid ".$menu['border_color_active'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li.active a");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li.active a";
        }
        $cssoutput .= " {
    color:".$menu['active_text_color'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li a:hover");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li a:hover";
        }
        $cssoutput .= " {
    color:#ffffff;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li > a");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li > a";
        }
        $cssoutput .= " {
    font-size:".$menu['font_size'].$menu['font_size_unit'].";
    font-weight:".$menu['font_weight'].";
    font-style:".$menu['font_style'].";
    color:".$menu['text_color'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li > a:hover");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li > a:hover";
        }
        $cssoutput .= " {
    color:".$menu['links_hover_color'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"ul");
        } else {
            $cssoutput .= "
.mnu_".$menu_name.", .mnu_".$menu_name." ul";
        }
        $cssoutput .= " {
    margin:0;
    padding:0;
    list-style-type:none;
    list-style-position:outside;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"li a");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." li a";
        }
        $cssoutput .= " {
    display:block;
    text-decoration:none;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> ul");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > ul";
        }
        $cssoutput .= " {
    position: absolute;
    z-index:200;
    float: left;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"ul");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." ul";
        }
        $cssoutput .= " {
    display:none;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li > ul > li");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li, .mnu_".$menu_name." > li  > ul > li";
        }
        $cssoutput .= " {
    float:left;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li:hover > ul").","
.cssselector(".mnu_",$menu_name,$menu_copies[$menu_name],"> li.active > ul");
        } else {
            $cssoutput .= "
.mnu_".$menu_name." > li:hover > ul, .mnu_".$menu_name." > li.active > ul";
        }
        $cssoutput .= " {
    display:block;
}
";

        $cssoutput .= "
.navh_submenu {
    font-family:".$menu['font_family_sub'].";
    float: left;
    clear: both;
}

.navh_submenu li {
    display: block;
}
";

        $cssoutput .= "
div.navh_submenu {";
        if ($menu['tab_color_sub']) {
            $cssoutput .= "
    background:".$menu['tab_color_sub'].";";
        }
        $cssoutput .= "
    height:".$menu['tab_height_sub'].$menu['tab_height_sub_unit'].";
    line-height:".$menu['tab_height_sub'].$menu['tab_height_sub_unit'].";
    width:100%;
}
";

        $cssoutput .= "
div.navh_submenu ul {
    margin: 0;
    padding: 0;
}

div.navh_submenu ul > li {
    padding:0 ".$menu['horiz_button_padding_sub'].$menu['horiz_button_padding_sub_unit'].";
    margin:0;
    float:left;
}

div.navh_submenu ul > li > a {
    color:".$menu['text_color_sub']." !important;
    font-size:".$menu['font_size_sub'].$menu['font_size_sub_unit'].";
    font-weight:".$menu['font_weight_sub'].";
    font-style:".$menu['font_style_sub'].";
}

div.navh_submenu ul > li > a:hover {
    color:".$menu['links_hover_color_sub']." !important;
}

div.navh_submenu ul > li > ul {
    padding:".$menu['horiz_pane_padding_sub_sub'].$menu['horiz_pane_padding_sub_sub_unit'].";";
        if ($menu['tab_color_sub_sub']) {
            $cssoutput .= "
    background:".$menu['tab_color_sub_sub'].";";
        }
        $cssoutput .= "
    position: absolute;
    margin-left:-".$menu['horiz_button_padding_sub'].$menu['horiz_button_padding_sub_unit'].";
}

div.navh_submenu ul > li > ul > li {
    width:".$menu['tab_width_sub_sub'].$menu['tab_width_sub_sub_unit'].";
    line-height:".$menu['horiz_pane_menu_item_height_sub_sub'].$menu['horiz_pane_menu_item_height_sub_sub_unit'].";
    padding:0;
    margin:0;
    float:none;
}

div.navh_submenu ul > li > ul > li > a {
    color:".$menu['text_color_sub_sub']." !important;
    font-size:".$menu['font_size_sub_sub'].$menu['font_size_sub_sub_unit'].";
}

div.navh_submenu ul > li > ul > li > a:hover {
    color:".$menu['links_hover_color_sub_sub']." !important;
}

div.navh_submenu ul ul ul {";
            $cssoutput .= "
    left:".$menu['tab_width_sub_sub'].$menu['tab_width_sub_sub_unit'].";";
        $cssoutput .= "
    margin-top:-40px;
}

div.navh_submenu > ul { 
    min-width: 100%;
    min-height: 30px;
    position:absolute;
    display:none;
}

div.navh_submenu > ul.active_sub {
    display:block;
    position:static;
}
";

    } elseif ($menu['type'] == "offcanvas") {

        // colors

        $offcanvas_colors_array = [$menu['background_color'], $menu['font_color'], $menu['font_color_hover'], $menu['font_color_sub'], $menu['font_color_sub_hover']];

        foreach ($offcanvas_colors_array as &$color) {
            if ($color == $tparams->sparkycolor1) {
                $color = "var(--sparkycolor1)";
            }
            if ($color == $tparams->sparkycolor2) {
                $color = "var(--sparkycolor2)";
            }
            if ($color == $tparams->sparkycolor3) {
                $color = "var(--sparkycolor3)";
            }
            if ($color == $tparams->sparkycolor4) {
                $color = "var(--sparkycolor4)";
            }
            if ($color == $tparams->sparkycolor5) {
                $color = "var(--sparkycolor5)";
            }
            if ($color == $tparams->sparkycolor6) {
                $color = "var(--sparkycolor6)";
            }
        }

        $menu['background_color'] = $offcanvas_colors_array[0];
        $menu['font_color'] = $offcanvas_colors_array[1];
        $menu['font_color_hover'] = $offcanvas_colors_array[2];
        $menu['font_color_sub'] = $offcanvas_colors_array[3];
        $menu['font_color_sub_hover'] = $offcanvas_colors_array[4];

        $cssoutput .= "

/* OFF-CANVAS MENU */

html, body {
    -webkit-tap-highlight-color: transparent;
    /* disable webkit tap highlight */
    overflow-x: hidden;
}

";
        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".container_",$menu_name,$menu_copies[$menu_name],"");
        } else {
            $cssoutput .= "
.container_".$menu_name;
        }
$cssoutput .= " {
    position: fixed;
    width:".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].";
    height: 100%;
    top: 0;
    z-index: 9999;
    background: ".$menu['background_color'].";
    overflow: auto;
    visibility: hidden;
    -webkit-overflow-scrolling: touch;
    /* enables momentum scrolling in iOS overflow elements */
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .= 
cssselector(".container_",$menu_name,$menu_copies[$menu_name],"a");
        } else {
    $cssoutput .= "
.container_".$menu_name." a";
        }
$cssoutput .= " {
    display: block;
    color: ".$menu['font_color'].";
    font-size:".$menu['font_size'].$menu['font_size_unit'].";
    font-family:".$menu['font_family'].";
    text-decoration: none;
    outline: 0;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .= 
cssselector(".container_",$menu_name,$menu_copies[$menu_name],"a:hover");
        } else {
    $cssoutput .= "
.container_".$menu_name." a:hover";
        }
$cssoutput .= " {
    color: ".$menu['font_color_hover'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .= 
cssselector(".container_",$menu_name,$menu_copies[$menu_name],"ul:first-child");
        } else {
    $cssoutput .= "
.container_".$menu_name." ul:first-child";
        }
$cssoutput .= " {
    margin-top: 10px;
}

.offcanvas-left {
    left: 0;
}

.offcanvas-right {
    right: 0;
}

/* Menu Movement */

.offcanvas-left {
    -webkit-transform: translate3d(-".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
    -ms-transform: translate3d(-".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
    transform: translate3d(-".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
}

.offcanvas-open-left .sparky_wrapper {
    -webkit-transform: translate3d(".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
    -ms-transform: translate3d(".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
    transform: translate3d(".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
}

.offcanvas-right {
    -webkit-transform: translate3d(".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
    -ms-transform: translate3d(".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
    transform: translate3d(".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
}

.offcanvas-open-right .sparky_wrapper {
    -webkit-transform: translate3d(-".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
    -ms-transform: translate3d(-".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
    transform: translate3d(-".$menu['offcanvas_width'].$menu['offcanvas_width_unit'].", 0, 0);
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .= 
cssselector(".offcanvas-open-left .container_",$menu_name,$menu_copies[$menu_name],"");
        } else {
    $cssoutput .= "
.offcanvas-open-left .container_".$menu_name;
        }
        $cssoutput .= ",";
        if (isset($menu_copies[$menu_name])) {
            $cssoutput .= 
cssselector(".offcanvas-open-right .container_",$menu_name,$menu_copies[$menu_name],"");
        } else {
    $cssoutput .= "
.offcanvas-open-right .container_".$menu_name;
        }
        $cssoutput .= " {
    -webkit-transform: translate3d(0, 0, 0);
    -ms-transform: translate3d(0, 0, 0);
    transform: translate3d(0, 0, 0);
}

/* Menu Transitions */

.sparky_wrapper,";
        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".container_",$menu_name,$menu_copies[$menu_name],"");
        } else {
            $cssoutput .= "
.container_".$menu_name;
        }
        $cssoutput .= " {
    transition: transform 0.2s cubic-bezier(0.16, 0.68, 0.43, 0.99);
}

/* Site Overlay */

.offcanvas-menu-overlay {
    display: none;
}

.offcanvas-open-left .offcanvas-menu-overlay,
.offcanvas-open-right .offcanvas-menu-overlay {
    display: block;
    position: fixed;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    z-index: 9998;
    background-color: rgba(".$menu['overlay_background_color'].", ".$menu['overlay_transparency'].");
    -webkit-animation: offcanvasfade 500ms;
    animation: offcanvasfade 500ms;
}

@keyframes offcanvasfade {
    0% {
        opacity: 0;
    }
    100% {
        opacity: 1;
    }
}

@-webkit-keyframes offcanvasfade {
    0% {
        opacity: 0;
    }
    100% {
        opacity: 1;
    }
}

/* Submenu Appearance */
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".container_",$menu_name,$menu_copies[$menu_name],".parent ul");
        } else {
            $cssoutput .= "
.container_".$menu_name." .parent ul";
        }
        $cssoutput .= " {
    padding-left: 15px;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".container_",$menu_name,$menu_copies[$menu_name],".parent > a");
        } else {
            $cssoutput .= "
.container_".$menu_name." .parent > a";
        }
        $cssoutput .= " {
    position: relative;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".container_",$menu_name,$menu_copies[$menu_name],".parent > a::after");
        } else {
            $cssoutput .= "
.container_".$menu_name." .parent > a::after";
        }
        $cssoutput .= " {
    content: '';
    display: block;
    height: 15px;
    width: 25px;
    position: absolute;
    top: 50%;
    right: 15px;
    background: url('../images/arrow_down.png') no-repeat;
    -webkit-transform: translateY(-50%);
    -ms-transform: translateY(-50%);
    transform: translateY(-50%);
    transition: transform 0.2s;
}

.offcanvas-".$menu['offcanvas_position']." h3 {
    margin:0;
    padding:15px;
    color: ".$menu['font_color'].";
}

ul.offcanvas_sparky {
    margin:0;
    padding:15px;
}

ul.offcanvas_sparky ul {
    margin:0;
    padding:5px 0;
}

ul.offcanvas_sparky ul a {
    font-size:".$menu['font_size_sub'].$menu['font_size_sub_unit'].";
    color: ".$menu['font_color_sub'].";
}

ul.offcanvas_sparky ul a:hover {
    color: ".$menu['font_color_sub_hover'].";
}

ul.offcanvas_sparky li {
    width:100%;
    list-style:none;
    margin:0;
    padding:3px 0;
}

/* Menu Button */

.offcanvas-btn {
    width: 42px;
    height: 42px;
    margin-bottom: 15px;
    background: url(../images/tinynav.png);
    background-size: 42px 84px;
    cursor: pointer;
    float: ".$menu['offcanvas_position'].";
}
";

    if( $menu['content_before_menu'] || $menu['content_after_menu'] ) {
        $cssoutput .= "
/* Text before/after menu */

.offcanvas_before_menu, .offcanvas_after_menu {
    padding:15px;
    color: ".$menu['font_color'].";
    font-size:".$menu['font_size'].$menu['font_size_unit'].";
    font-family:".$menu['font_family'].";
}

";
}

    } elseif ($menu['type'] == "mega") {

        // calculate overall pane width
        $overall_pane_width = $menu['mega_pane_width'] * $menu['max_columns'] + $menu['pane_border_size'] * 2;

        // calculate top margin due to borders
        $move_pane_up = $menu['pane_border_size'] + $menu['border_size_first_lvl'];

        // colors

        $mega_colors_array = [$menu['border_color_first_lvl'], $menu['button_bg'], $menu['active_button_bg'], $menu['button_hover_bg'], $menu['text_color'], $menu['links_hover_color'], $menu['active_text_color'], $menu['pane_border_color'], $menu['mega_pane_bg'], $menu['text_color_sub'], $menu['border_color_horiz_sub_lvl'], $menu['links_hover_color_sub'], $menu['text_color_sub_sub'], $menu['links_hover_color_sub_sub']];

        foreach ($mega_colors_array as &$color) {
            if ($color == $tparams->sparkycolor1) {
                $color = "var(--sparkycolor1)";
            }
            if ($color == $tparams->sparkycolor2) {
                $color = "var(--sparkycolor2)";
            }
            if ($color == $tparams->sparkycolor3) {
                $color = "var(--sparkycolor3)";
            }
            if ($color == $tparams->sparkycolor4) {
                $color = "var(--sparkycolor4)";
            }
            if ($color == $tparams->sparkycolor5) {
                $color = "var(--sparkycolor5)";
            }
            if ($color == $tparams->sparkycolor6) {
                $color = "var(--sparkycolor6)";
            }
        }

        $menu['border_color_first_lvl'] = $mega_colors_array[0];
        $menu['button_bg'] = $mega_colors_array[1];
        $menu['active_button_bg'] = $mega_colors_array[2];
        $menu['button_hover_bg'] = $mega_colors_array[3];
        $menu['text_color'] = $mega_colors_array[4];
        $menu['links_hover_color'] = $mega_colors_array[5];
        $menu['active_text_color'] = $mega_colors_array[6];
        $menu['pane_border_color'] = $mega_colors_array[7];
        $menu['mega_pane_bg'] = $mega_colors_array[8];
        $menu['text_color_sub'] = $mega_colors_array[9];
        $menu['border_color_horiz_sub_lvl'] = $mega_colors_array[10];
        $menu['links_hover_color_sub'] = $mega_colors_array[11];
        $menu['text_color_sub_sub'] = $mega_colors_array[12];
        $menu['links_hover_color_sub_sub'] = $mega_colors_array[13];
        

        $cssoutput .= "
/* MEGA MENU */

";
        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.menu.mega.mnu_",$menu_name,$menu_copies[$menu_name],"");
        } else {
            $cssoutput .= "
ul.mega.mnu_".$menu_name;
        }
        $cssoutput .= " {
    display:none;
}

.megamenu_blocks {
    display:none;
}

";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.hjt-megamenu-menubar.mnu_",$menu_name,$menu_copies[$menu_name],"");
        } else {
            $cssoutput .= "
ul.hjt-megamenu-menubar.mnu_".$menu_name;
        }
        $cssoutput .= " {
    display:none;
    position:relative;
    white-space:nowrap;
    list-style: none;
    height:".$menu['bar_height'].$menu['bar_height_unit'].";
    margin:0;
    padding:0;
    z-index:999;
    text-align: ".$menu['alignment'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item";
        }
        $cssoutput .= " {
    display:inline-block;
    margin:0;
    padding:0 ".$menu['horizontal_padding'].$menu['horizontal_padding_unit'].";";
        if ($menu['main_level_width'] != 0) {
            $cssoutput .= "
    width:".$menu['main_level_width'].$menu['main_level_width_unit'].";";
        }
        $cssoutput .= "
    height:".$menu['bar_height'].$menu['bar_height_unit'].";
    line-height:".$menu['bar_height'].$menu['bar_height_unit'].";
    z-index:999;
    text-align: ".$menu['text_align'].";
    border:".$menu['border_size_first_lvl']."px solid ".$menu['border_color_first_lvl'].";";
            $cssoutput .= "
    border-left:0;";
        $cssoutput .= "
    background:".$menu['button_bg'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item:last-child");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item:last-child";
        }
        $cssoutput .= " {";
            $cssoutput .= "
    border-left:".$menu['border_size_first_lvl']."px solid ".$menu['border_color_first_lvl'].";";
        $cssoutput .= "
    
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item.active");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item.active";
        }
        $cssoutput .= " {
    background:".$menu['active_button_bg'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item:hover");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item:hover";
        }
        $cssoutput .= " {
    background:".$menu['button_hover_bg'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item-normal");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item-normal";
        }
        $cssoutput .= " {
    z-index:999;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item-normal a");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item-normal a";
        }
        $cssoutput .= " {
    z-index:999;
    display:block;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-droparrow");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-droparrow";
        }
        $cssoutput .= " {
    display:inline-block;
    background:url(../images/arrow_down.png) center no-repeat;";
            $cssoutput .= "
    margin: 0 10px 0 0;";
        $cssoutput .= "
    width:25px;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item a");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item a";
        }
        $cssoutput .= " {
    text-decoration:none; 
    display:block;
    color:".$menu['text_color'].";
    font-family:".$menu['font_family'].";
    font-style:".$menu['font_style'].";
    font-weight:".$menu['font_weight'].";
    font-size:".$menu['font_size'].$menu['font_size_unit'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item .hjt-megamenu-dropdown-panel a");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item .hjt-megamenu-dropdown-panel a";
        }
        $cssoutput .= " {
    height:".$menu['subitems_height'].$menu['subitems_height_unit'].";
    line-height:".$menu['subitems_height'].$menu['subitems_height_unit'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item-hover a");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item-hover a";
        }
        $cssoutput .= " {
    color:".$menu['links_hover_color'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item.active a");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item.active a";
        }
        $cssoutput .= " {
    color:".$menu['active_text_color'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-dropdown-panel");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-dropdown-panel";
        }
        $cssoutput .= " {
    position:absolute; 
    display:none;  
    z-index:1000; 
    padding:0;
    white-space:normal;
    width:".$overall_pane_width."px;
    border:".$menu['pane_border_size']."px solid ".$menu['pane_border_color'].";
    margin-top:-".$move_pane_up."px;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-dropdown-panel .mega_menu_table");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-dropdown-panel .mega_menu_table";
        }
        $cssoutput .= " {
    background:".$menu['mega_pane_bg'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-dropdown-panel-list");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-dropdown-panel-list";
        }
        $cssoutput .= " {
    margin:0; 
    padding:0;
    list-style:none;
    text-align:".$menu['sub_sub_text_align'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-dropdown-panel-list li");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-dropdown-panel-list li";
        }
        $cssoutput .= " {
    white-space:normal;
    margin:0;
    padding:0;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item a.hjt-megamenu-dropdown-panel-list-title");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item a.hjt-megamenu-dropdown-panel-list-title";
        }
        $cssoutput .= " {
    display:block;
    font-family:".$menu['font_family_sub'].";
    font-style:".$menu['font_style_sub'].";
    font-weight:".$menu['font_weight_sub'].";
    font-size:".$menu['font_size_sub'].$menu['font_size_sub_unit'].";
    color:".$menu['text_color_sub'].";
    border-bottom:".$menu['border_size_horiz_sub_lvl']."px solid ".$menu['border_color_horiz_sub_lvl'].";
    margin-bottom:10px;
    text-align:".$menu['sub_text_align'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item a.hjt-megamenu-dropdown-panel-list-title:hover");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item a.hjt-megamenu-dropdown-panel-list-title:hover";
        }
        $cssoutput .= " {
    color:".$menu['links_hover_color_sub'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item .hjt-megamenu-dropdown-panel-list a");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item .hjt-megamenu-dropdown-panel-list a";
        }
        $cssoutput .= " {
    font-family:".$menu['font_family_sub_sub'].";
    font-style:".$menu['font_style_sub_sub'].";
    font-weight:".$menu['font_weight_sub_sub'].";
    font-size:".$menu['font_size_sub_sub'].$menu['font_size_sub_sub_unit'].";
    color:".$menu['text_color_sub_sub'].";
    height:".$menu['sub_subitems_height'].$menu['sub_subitems_height_unit'].";
    line-height:".$menu['sub_subitems_height'].$menu['sub_subitems_height_unit'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item .hjt-megamenu-dropdown-panel-list a:hover");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-menubar-item .hjt-megamenu-dropdown-panel-list a:hover";
        }
        $cssoutput .= " {
    color:".$menu['links_hover_color_sub_sub'].";
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-dropdown-panel-content");
        } else {
            $cssoutput .= "
ul.mnu_".$menu_name." .hjt-megamenu-dropdown-panel-content";
        }
        $cssoutput .= " {
    display:inline-block;
    font-size:12px;
    vertical-align:top;
    width:".$menu['mega_pane_width']."px;
    padding:".$menu['mega_pane_padding'].$menu['mega_pane_padding_unit'].";
}
";

        if($tparams->enableResponsiveMenu) {

            if (isset($menu_copies[$menu_name])) {
                $cssoutput .=
cssselector(".nav-collapse.opened ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-dropdown-panel-content ul");
            } else {
                $cssoutput .= "
.nav-collapse.opened ul.mnu_".$menu_name." .hjt-megamenu-dropdown-panel-content ul";
            }
            $cssoutput .= " {
    background:transparent;
}
";

            if (isset($menu_copies[$menu_name])) {
                $cssoutput .=
cssselector(".nav-collapse.opened ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item a.hjt-megamenu-dropdown-panel-list-title");
            } else {
                $cssoutput .= "
.nav-collapse.opened ul.mnu_".$menu_name." .hjt-megamenu-menubar-item a.hjt-megamenu-dropdown-panel-list-title";
            }
            $cssoutput .= " {
    color:".$menu['text_color_sub']." !important;
}
";

            if (isset($menu_copies[$menu_name])) {
                $cssoutput .=
cssselector(".nav-collapse.opened ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item .hjt-megamenu-dropdown-panel-list a");
            } else {
                $cssoutput .= "
.nav-collapse.opened ul.mnu_".$menu_name." .hjt-megamenu-menubar-item .hjt-megamenu-dropdown-panel-list a";
            }
            $cssoutput .= " {
    color:".$menu['text_color_sub_sub']." !important;
}
";

            if (isset($menu_copies[$menu_name])) {
                $cssoutput .=
cssselector(".nav-collapse.opened ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-dropdown-panel-list li:hover");
            } else {
            $cssoutput .= "
.nav-collapse.opened ul.mnu_".$menu_name." .hjt-megamenu-dropdown-panel-list li:hover";
            }
            $cssoutput .= " {
    background:transparent;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".nav-collapse.opened ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item");
        } else {
            $cssoutput .= "
.nav-collapse.opened ul.mnu_".$menu_name." .hjt-megamenu-menubar-item";
        }
        $cssoutput .= " {
    background:#333;";
            $cssoutput .= "
    border-left:".$menu['border_size_first_lvl']."px solid ".$menu['border_color_first_lvl'].";";
        $cssoutput .= "
    border-top:0;
    height:auto;
}
";

        if (isset($menu_copies[$menu_name])) {
            $cssoutput .=
cssselector(".nav-collapse.opened ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-menubar-item a");
        } else {
            $cssoutput .= "
.nav-collapse.opened ul.mnu_".$menu_name." .hjt-megamenu-menubar-item a";
        }
        $cssoutput .= " {
    padding:0;
    height:auto;
    line-height:inherit;
}
";

            $cssoutput .= "
@media screen and (max-width: ".str_replace("@", "", $tparams->responsiveMenuTriggerValue).") {
    ";

            if (isset($menu_copies[$menu_name])) {
                $cssoutput .=
    cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-dropdown-panel");
            } else {
                $cssoutput .= "
    ul.mnu_".$menu_name." .hjt-megamenu-dropdown-panel";
            }
            $cssoutput .= " {
        position:relative;
        width:100%;
        border:0;
    }";

            if ($menu['modules_mobile'] != 1) {
                if (isset($menu_copies[$menu_name])) {
                    $cssoutput .=
    cssselector("ul.mnu_",$menu_name,$menu_copies[$menu_name],".hjt-megamenu-dropdown-panel-content");
                } else {
                    $cssoutput .= "
    ul.mnu_".$menu_name." .hjt-megamenu-dropdown-panel-content";
                }
                $cssoutput .= " {
        width:".$menu['mega_pane_width_mobile']."px;
    }
    ";
            }
            $cssoutput .= "
}
";
        } // If responsive menu enabled END
    } // Mega Menu END
} // Menus rendering END


////////////// Responsive menu
//////////////////////////////

if($tparams->enableResponsiveMenu) {

    $responsiveMenuTriggerValue1 = explode('@', $tparams->responsiveMenuTriggerValue);
    $responsiveMenuTriggerValue1[0] -= 1;

    $cssoutput .= "
/* RESPONSIVE TOP MENU */

.js .nav-collapse {
    clip: rect(0 0 0 0);
    max-height: 0;
    position: absolute;
    display: block;
    zoom: 1;
}

.nav-collapse.opened {
    max-height: 9999px;
    position:absolute;
}

.nav-collapse.opened > ul {
    position: fixed;
    top: 0;
    left: 5%;
    width: 90%;
    height: auto;
    background:#444;
}

.nav-collapse.opened > ul ul {
    width: 100%;
    position: relative;
    left:0;
    padding:0;
    margin:0;
    background:#444;
    border:0;
}

.nav-collapse.opened > ul ul li {
    height:auto;
}

.nav-collapse.opened li {
    width: 100%;
    display: block;
    padding-left: 0;
    padding-right: 0;
    margin-bottom: 0;
    text-align:initial;
}

.nav-collapse.opened li.active, .nav-collapse.opened li:hover {
    background-color:#333;
}

.nav-collapse.opened li.active a {
    color:#fff !important;
}

.nav-collapse.opened li a,
.nav-collapse.opened li span {
    padding:0 15px;
    margin:0;
    line-height:50px;
    height:50px;
    color:#fff !important;
}

.nav-collapse.opened li li a,
.nav-collapse.opened li li span {
    padding:0 30px;
    line-height:30px;
    height:30px;
}

.nav-toggle {
    -webkit-tap-highlight-color: rgba(0,0,0,0);
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    -o-user-select: none;
    user-select: none;";
    if ($tparams->menuIconImage != -1 && $tparams->menuIconImage != "") {
        $cssoutput .= "
    background: url('../images/".$tparams->menuIconImage."');";
    } else {
        $cssoutput .= "
    background: url('../images/tinynav.png');";
    }
    $cssoutput .= "
    background-size: 42px 84px;
    width: 42px;
    height: 42px;
    text-indent:-9999px;
    display:inline-block;
    float:right;
}

.nav-toggle.active {
    position: fixed;
    z-index: 999;
    right: 5%;
    top: 0;
    margin-top:5px;
    margin-right:15px;
    background-position: bottom;
}

#blocker {
    position:fixed;
    width:100%;
    height:100%;
    left:0;
    top:0;
    right:0;
    bottom:0;
    z-index:9999;
}

@media screen and (min-width: ".str_replace("@", "", $tparams->responsiveMenuTriggerValue).") {

    .js .nav-collapse {
        position: relative;
    }

    .js .nav-collapse.closed {
        max-height: none;
    }

    .nav-toggle {
        display: none;
    }

}

@media screen and (max-width: ".$responsiveMenuTriggerValue1[0].$responsiveMenuTriggerValue1[1].") {

    .nav-collapse.closed {
        overflow:hidden;
    }

    .firstClick + ul {
        display: none !important;
    }

}
    ";
}

////////////// Top panel
////////////////////////

if ($tparams->topPanelSwitch) {
    $cssoutput .= "
/* TOP PANEL */

.sparky_top_panel_button {
    width:".str_replace("@", "", $tparams->topPanelButtonWidth).";
    height:".str_replace("@", "", $tparams->topPanelButtonHeight).";
    line-height:".$tparams->topPanelButtonHeight."px;
    background:".$tparams->topPanelButtonBgColor.";
    color:".$tparams->topPanelButtonTextColor.";
    font-size:".str_replace("@", "", $tparams->topPanelButtonTextSize).";
    border:1px solid ".$tparams->topPanelButtonBorderColor.";
    border-top:none;
    border-radius:0 0 ".$tparams->topPanelButtonBorderRadius."px ".$tparams->topPanelButtonBorderRadius."px;
    position:relative;
    z-index:1000;
}

.sparky_top_panel_container h3 {
    color:".$tparams->topPanelH3Color.";
}

.sparky_top_panel_container {
    color:".$tparams->topPanelTextColor.";
    position:absolute;
    width:100%;
}

.sparky_top_panel_button {
    margin:0 auto;
    text-align:center;
    cursor:pointer;
}

.close_button {
    display:none;
}
";
}

////////////// Scroll to top
////////////////////////////

if ($tparams->scrollToTopImageFile != -1 && $tparams->scrollToTopImageFile != "") {
    $cssoutput .= "
/* SCROLL TO TOP */

#back-top {
    position: fixed;";
    if ($tparams->scrollToTopPosition == "bottom_right") {
        $cssoutput .= "
    bottom: 25px;
    right: 25px;";
    } elseif ($tparams->scrollToTopPosition == "bottom_left") {
        $cssoutput .= "
    bottom: 25px;
    left: 25px;";
    } elseif ($tparams->scrollToTopPosition == "top_right") {
        $cssoutput .= "
    top: 5px;
    right: 25px;";
    } else {
        $cssoutput .= "
    top: 5px;
    left: 25px;";
    }
    $cssoutput .= "
}

#back-top span {
    width: 60px;
    height: 60px;
    display: block;
    margin-bottom: 7px;
    background: url('../images/".$tparams->scrollToTopImageFile."') no-repeat center center;
    background-size: contain;
    cursor: pointer;
    transition: 1s;
}
";
}

////////////// Font resize
//////////////////////////

if ($font_resize_enabled) {
    $cssoutput .= "
/* FONT RESIZE */

#font_resize a {
    padding:0 2px;
}
";
}

////////////// Image animation
//////////////////////////////

if ($tparams->imageAnimation) {
    $cssoutput .= "
/* IMAGE ANIMATION */

.img-with-animation {
    opacity: 0;
    position: relative;
}

.img-with-animation[data-animation='grow-in'] {
    opacity: 0;
    transform: scale(0.4);
    transition: opacity 0.6s cubic-bezier(0.15, 0.84, 0.35, 1.25);}

.img-with-animation[data-animation='fade-in-from-left'] {
    left: -40px;
}

.img-with-animation[data-animation='fade-in-from-right'] {
    right: -40px;
}

.img-with-animation[data-animation='fade-in-from-bottom'] {
    bottom: -100px;
}
";
}

////////////// Floating row
///////////////////////////

if ($floating_rows > 0) {

    $cssoutput .= "
/* FLOATING ROW (usually for top menu) */

@keyframes topmenushow {
    0% {
        opacity: 1;
        transform: translateY(-50px);
    }
    
    100% {
        opacity: 1;
        transform: translateY(0);
    }
}

.fix_menu {
    position: fixed;
    top: 0;
    z-index: 89;
    width: 100%;
    background: rgba(255,255,255,.9) !important;
}

.topmenushow {
    animation-name: topmenushow;
    animation-fill-mode: both;
    animation-duration: .5s;
}
";
}

////////////// Joomla! elements
///////////////////////////////

$cssoutput .= "
.element-invisible {
    display:none !important;
}

/* forms */

.input-group {
    margin-bottom:15px;
}

.has-danger input {
    border-color:red;
}

.form-control-feedback {
    color:red;
    padding: 0 15px;
}

.control-group {
    margin-bottom:15px;
}

.input-prepend .add-on,
.input-prepend .btn,
a.jmodedit {
    box-sizing: content-box;
}

.nav-tabs.nav-stacked {
    margin:0;
}

a.modal.btn, a.btn.hasTooltip, a.btn.modal-button {
    font-size:13px;
}

a.jmodedit.btn {
    text-decoration: none;
}

.input-password-toggle .icon-eye::before {
    content: '\\f06e';
}

.input-password-toggle .icon-eye-slash::before {
    content: '\\f070';
}

.btn .icon-edit::before {
    content: '\\f044';
}

/* front-end edit */

.edit.item-page button span {
    margin:0 5px;
}

#jform_publish_up_img, #jform_publish_down_img {
    padding:7px 12px 6px;
}

#modules-form legend {
    border:0;
    padding:0;
    margin-bottom:15px;
    font-size:18px;
}

#jformposition_chzn ul.chzn-results li:nth-child(1),
#jformposition_chzn ul.chzn-results li:nth-child(2),
#jformposition_chzn ul.chzn-results li:nth-child(3) {
    display:none;
} 

/* article info */

dl.article-info {
    display:inline-block;
    width:auto;
    margin:0 0 10px;
    padding:4px 3px 3px;
    font-size:13px;
}

dl.article-info dt.article-info-term {
    display:none;
}

dl.article-info dd {
    display:inline-block;
    padding:0 5px;
    margin:0;
    border-right:1px solid #ccc;
}

dl.article-info dd:first-of-type {
    padding:0 5px 0 0;
}

dl.article-info dd:last-child {
    border:0;
}

/* print/email drop-down */

.items-leading .icons,
.items-row .icons {
    float:right;
    width:15%;
}

.dropdown-menu li a span {
    padding:0 10px;
    background-image:none !important;
}

.dropdown-menu li a span:before {
    margin-left:-10px;
}

/* pagination */

.icon-angle-left:before {
    content: '\\f104';
}

.icon-angle-double-left:before {
    content: '\\f100';
}

.icon-angle-right:before {
    content: '\\f105';
}

.icon-angle-double-right:before {
    content: '\\f101';
}

/* pager */

.pager li > a, .pager li > span {
    background: transparent;
    border: 1px solid #121212;
    border-radius: 0;
    color: #121212;
    font-size: 14px;
    font-weight: 700;
    padding: 12px 25px;
    text-transform: uppercase;
}

/* tags */

ul.tags.list-inline, .mod-tagspopular ul {
    margin:0;
    padding:15px 0;
    list-style:none;
}

ul.tags.list-inline li, .mod-tagspopular ul li {
    display:inline-block;
    border:1px solid #ccc;
    padding:0;
    border-radius:4px;
    line-height:13px;
}

ul.tags.list-inline li:hover, .mod-tagspopular ul li:hover {
    background:#f5f5f5;
}

ul.tags.list-inline li a.btn, .mod-tagspopular ul li a {
    display:inline-block;
    background:none;
    border:none;
    text-shadow:none;
    color:#999;
    padding:5px;
    margin:0;
    font-size:13px;
    line-height:13px;
}

ul.tags.list-inline li a.btn:hover, .mod-tagspopular ul li a:hover {
    color:#666 !important;
}

/* rating */

.content_rating {
    display: inline-block;
    margin-inline-end: 15px;
}

.content_vote {
    display: inline-block;
    margin-bottom: 15px;
}

.content_rating ul {
    margin: 0 0 15px;
}

.content_vote select {
    display: inline-block;
    height: 30px;
}

.content_vote input.btn {
    height: 30px;
    line-height: 30px;
    padding-top: 0;
    padding-bottom: 0;
}

/* blog */

.items-more ol.nav {
    margin:0;
}

.items-more ol.nav li a {
    border:0;
    padding:5px 0;
}

.items-more ol.nav li a:hover,
.items-more ol.nav li a:focus {
    background:none;
}

/* category */

ul.category {
    margin:0;
    padding:0;
    list-style:none;
}

ul.category li {
    padding:10px 0;
}

ul.category li .list-title {
    font-size:18px;
}

/* contact form */


/* search form */

ol.com-finder__results-list,
ol.com-finder__results-list ul.result__taxonomy {
    margin: 0;
}

.com-finder__explained {
    padding-bottom: 30px;
}

/* user */

.registration legend,
.profile-edit legend {
    border:0;
    font-size:18px;
}

ul.mod-login__options {
    margin-left:0;
    margin-right:0;
}

/* breadcrumbs */

ol.mod-breadcrumbs {
    margin: 0;
}

/* faq */

.accordion-header {
    padding: 0;
}

";

////////////// Page transitions
///////////////////////////////

if ($tparams->pageTransition) {
    $cssoutput .= "
/**********************
 *CSS Animations by:
 *http://codepen.io/vivinantony
***********************/
.spinner1 {
    width: 40px;
    height: 40px;
    position: relative;
}

.double-bounce1, .double-bounce2 {
    width: 100%;
    height: 100%;
    border-radius: 50%;
    background-color: #fff;
    opacity: 0.6;
    position: absolute;
    top: 0;
    left: 0;
    -webkit-animation: bounce 2.0s infinite ease-in-out;
    animation: bounce 2.0s infinite ease-in-out;
}

.double-bounce2 {
    -webkit-animation-delay: -1.0s;
    animation-delay: -1.0s;
}

.spinner2 {
    width: 40px;
    height: 40px;
    position: relative;
}

.container1 > div, .container2 > div, .container3 > div {
    width: 6px;
    height: 6px;
    background-color: #fff;
    border-radius: 100%;
    position: absolute;
    -webkit-animation: bouncedelay 1.2s infinite ease-in-out;
    animation: bouncedelay 1.2s infinite ease-in-out;
    -webkit-animation-fill-mode: both;
    animation-fill-mode: both;
}

.spinner2 .spinner-container {
    position: absolute;
    width: 100%;
    height: 100%;
}

.container2 {
    -webkit-transform: rotateZ(45deg);
    transform: rotateZ(45deg);
}

.container3 {
    -webkit-transform: rotateZ(90deg);
    transform: rotateZ(90deg);
}

.circle1 { top: 0; left: 0; }
.circle2 { top: 0; right: 0; }
.circle3 { right: 0; bottom: 0; }
.circle4 { left: 0; bottom: 0; }

.container2 .circle1 {
    -webkit-animation-delay: -1.1s;
    animation-delay: -1.1s;
}

.container3 .circle1 {
    -webkit-animation-delay: -1.0s;
    animation-delay: -1.0s;
}

.container1 .circle2 {
    -webkit-animation-delay: -0.9s;
    animation-delay: -0.9s;
}

.container2 .circle2 {
    -webkit-animation-delay: -0.8s;
    animation-delay: -0.8s;
}

.container3 .circle2 {
    -webkit-animation-delay: -0.7s;
    animation-delay: -0.7s;
}

.container1 .circle3 {
    -webkit-animation-delay: -0.6s;
    animation-delay: -0.6s;
}

.container2 .circle3 {
    -webkit-animation-delay: -0.5s;
    animation-delay: -0.5s;
}

.container3 .circle3 {
    -webkit-animation-delay: -0.4s;
    animation-delay: -0.4s;
}

.container1 .circle4 {
    -webkit-animation-delay: -0.3s;
    animation-delay: -0.3s;
}

.container2 .circle4 {
    -webkit-animation-delay: -0.2s;
    animation-delay: -0.2s;
}

.container3 .circle4 {
    -webkit-animation-delay: -0.1s;
    animation-delay: -0.1s;
}

@-webkit-keyframes bouncedelay {
    0%, 80%, 100% { -webkit-transform: scale(0.0) }
    40% { -webkit-transform: scale(1.0) }
}

@keyframes bouncedelay {
    0%, 80%, 100% { 
        transform: scale(0.0);
        -webkit-transform: scale(0.0);
    } 40% { 
        transform: scale(1.0);
        -webkit-transform: scale(1.0);
    }
}

.spinner3 {
    width: 40px;
    height: 40px;
    position: relative;  
    -webkit-animation: rotate 2.0s infinite linear;
    animation: rotate 2.0s infinite linear;
}

.dot1, .dot2 {
    width: 60%;
    height: 60%;
    display: inline-block;
    position: absolute;
    top: 0;
    background-color: #fff;
    border-radius: 100%;
    -webkit-animation: bounce 2.0s infinite ease-in-out;
    animation: bounce 2.0s infinite ease-in-out;
}

.dot2 {
    top: auto;
    bottom: 0px;
    -webkit-animation-delay: -1.0s;
    animation-delay: -1.0s;
}

@-webkit-keyframes rotate {
    100% { -webkit-transform: rotate(360deg) }
}
@keyframes rotate {
    100% { transform: rotate(360deg); -webkit-transform: rotate(360deg) }
}

@-webkit-keyframes bounce {
    0%, 100% { -webkit-transform: scale(0.0) }
    50% { -webkit-transform: scale(1.0) }
}

@keyframes bounce {
    0%, 100% { 
        transform: scale(0.0);
        -webkit-transform: scale(0.0);
    } 50% { 
        transform: scale(1.0);
        -webkit-transform: scale(1.0);
    }
}

.spinner4 {
    width: 30px;
    height: 30px;
    background-color: #fff;
    -webkit-animation: rotateplane 1.2s infinite ease-in-out;
    animation: rotateplane 1.2s infinite ease-in-out;
}

@-webkit-keyframes rotateplane {
    0% { -webkit-transform: perspective(120px) }
    50% { -webkit-transform: perspective(120px) rotateY(180deg) }
    100% { -webkit-transform: perspective(120px) rotateY(180deg)  rotateX(180deg) }
}

@keyframes rotateplane {
    0% { 
        transform: perspective(120px) rotateX(0deg) rotateY(0deg);
        -webkit-transform: perspective(120px) rotateX(0deg) rotateY(0deg);
    } 50% { 
        transform: perspective(120px) rotateX(-180.1deg) rotateY(0deg);
        -webkit-transform: perspective(120px) rotateX(-180.1deg) rotateY(0deg);
    } 100% { 
        transform: perspective(120px) rotateX(-180deg) rotateY(-179.9deg);
        -webkit-transform: perspective(120px) rotateX(-180deg) rotateY(-179.9deg);
    }
}

.spinner5 {
    width: 32px;
    height: 32px;
    position: relative;
}

.cube1, .cube2 {
    background-color: #fff;
    width: 10px;
    height: 10px;
    position: absolute;
    top: 0;
    left: 0;
    -webkit-animation: cubemove 1.8s infinite ease-in-out;
    animation: cubemove 1.8s infinite ease-in-out;
}

.cube2 {
    -webkit-animation-delay: -0.9s;
    animation-delay: -0.9s;
}

@-webkit-keyframes cubemove {
    25% { -webkit-transform: translateX(42px) rotate(-90deg) scale(0.5) }
    50% { -webkit-transform: translateX(42px) translateY(42px) rotate(-180deg) }
    75% { -webkit-transform: translateX(0px) translateY(42px) rotate(-270deg) scale(0.5) }
    100% { -webkit-transform: rotate(-360deg) }
}

@keyframes cubemove {
    25% { 
        transform: translateX(42px) rotate(-90deg) scale(0.5);
        -webkit-transform: translateX(42px) rotate(-90deg) scale(0.5);
    } 50% { 
        transform: translateX(42px) translateY(42px) rotate(-179deg);
        -webkit-transform: translateX(42px) translateY(42px) rotate(-179deg);
    } 50.1% { 
        transform: translateX(42px) translateY(42px) rotate(-180deg);
        -webkit-transform: translateX(42px) translateY(42px) rotate(-180deg);
    } 75% { 
        transform: translateX(0px) translateY(42px) rotate(-270deg) scale(0.5);
        -webkit-transform: translateX(0px) translateY(42px) rotate(-270deg) scale(0.5);
    } 100% { 
        transform: rotate(-360deg);
        -webkit-transform: rotate(-360deg);
    }
}

.spinner6 {
    width: 50px;
    height: 30px;
    text-align: center;
}

.spinner6 > div {
    background-color: #fff;
    height: 100%;
    width: 6px;
    margin-left:2px;
    display: inline-block;
    -webkit-animation: stretchdelay 1.2s infinite ease-in-out;
    animation: stretchdelay 1.2s infinite ease-in-out;
}

.spinner6 .rect2 {
    -webkit-animation-delay: -1.1s;
    animation-delay: -1.1s;
}

.spinner6 .rect3 {
    -webkit-animation-delay: -1.0s;
    animation-delay: -1.0s;
}

.spinner6 .rect4 {
    -webkit-animation-delay: -0.9s;
    animation-delay: -0.9s;
}

.spinner6 .rect5 {
    -webkit-animation-delay: -0.8s;
    animation-delay: -0.8s;
}

@-webkit-keyframes stretchdelay {
    0%, 40%, 100% { -webkit-transform: scaleY(0.4) }  
    20% { -webkit-transform: scaleY(1.0) }
}

@keyframes stretchdelay {
    0%, 40%, 100% { 
        transform: scaleY(0.4);
        -webkit-transform: scaleY(0.4);
    }  20% { 
        transform: scaleY(1.0);
        -webkit-transform: scaleY(1.0);
    }
}

.spinner7 {
    width: 90px;
    height: 30px;
    text-align: center;
}

.spinner7 > div {
    background-color: #fff;
    height: 15px;
    width: 15px;
    margin-left:3px;
    border-radius: 50%;
    display: inline-block;
    -webkit-animation: stretchdelay 0.7s infinite ease-in-out;
    animation: stretchdelay 0.7s infinite ease-in-out;
}

.spinner7 .circ2 {
    -webkit-animation-delay: -0.6s;
    animation-delay: -0.6s;
}

.spinner7 .circ3 {
    -webkit-animation-delay: -0.5s;
    animation-delay: -0.5s;
}

.spinner7 .circ4 {
    -webkit-animation-delay: -0.4s;
    animation-delay: -0.4s;
}

.spinner7 .circ5 {
    -webkit-animation-delay: -0.3s;
    animation-delay: -0.3s;
}

@-webkit-keyframes stretchdelay {
    0%, 40%, 100% { -webkit-transform: translateY(-10px) }  
    20% { -webkit-transform: translateY(-20px) }
}

@keyframes stretchdelay {
    0%, 40%, 100% { 
        transform: translateY(-10px);
        -webkit-transform: translateY(-10px);
    } 20% {
        transform: translateY(-20px);
        -webkit-transform: translateY(-20px);
    }
}

.fl.spinnerimage {
    background:url(../images/".$tparams->pageTransitionImage.") center no-repeat;
    width: 100%;
    height: 100%;
    left: 0 !important;
    top: 0 !important;
}

#page_transition_mask {
    position: fixed;
    width: 100%;
    height: 100%;
    top: 0px;
    left: 0px;
    background-color: rgb(97, 191, 129);
    z-index: 999;
    display: block;
}
";
}

////////////// Custom CSS
/////////////////////////

$cssoutput .= "
/* Custom user code */

".$tparams->customcodecss;
