<?php
/*------------------------------------------------------------------------
# "Sparky Framework" - Joomla Template Framework
# Copyright (C) 2016 HotThemes. All Rights Reserved.
# License: http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
# Author: HotThemes
# Website: http://www.hotjoomlatemplates.com
-------------------------------------------------------------------------*/

defined('JPATH_BASE') or die;
if(!defined('DS')) {
    define("DS", DIRECTORY_SEPARATOR);
}
jimport('joomla.form.formfield');
/**
 * Form Field class for the Joomla Framework.
 *
 * @package		Joomla.Framework
 * @subpackage	Form
 * @since		1.6
 */
 

class JFormFieldTadmin extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'tadmin';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
	    global $TEMPLATE_FOLDER;
	    global $tparams;

	    $TEMPLATE_FOLDER = basename(realpath( dirname(__FILE__) . DIRECTORY_SEPARATOR . '..'));
	
 	    $document = JFactory::getDocument();

 	    // get params for template style that's being edited
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query
			->select('*')
			->from('#__template_styles')
			->where('id='.$_GET["id"]);

		$db->setQuery($query);
		$db->execute();
		$template_style = $db->loadObjectList();

		// decode template style params - you'll need them for CSS
		$tparams = json_decode($template_style[0]->params);

 	    // backend inline CSS
 	    $document->addStyleDeclaration(":root {
		  --sparkycolor1: ".$tparams->sparkycolor1.";
		  --sparkycolor2: ".$tparams->sparkycolor2.";
		  --sparkycolor3: ".$tparams->sparkycolor3.";
		  --sparkycolor4: ".$tparams->sparkycolor4.";
		  --sparkycolor5: ".$tparams->sparkycolor5.";
		  --sparkycolor6: ".$tparams->sparkycolor6.";
		}");

		// backend CSS
		$document->addStyleSheet(JURI::root(1) . '/media/templates/site/sparky_framework/css/admin/modal.css');
		$document->addStyleSheet(JURI::root(1) . '/media/templates/site/sparky_framework/css/admin/tadmin.css');
		$document->addStyleSheet(JURI::root(1) . '/media/templates/site/sparky_framework/css/admin/codemirror.css');

		// code mirror
		$document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/admin/codemirror/codemirror.js');
	    $document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/admin/codemirror/css.js');
	    $document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/admin/codemirror/javascript.js');

	    // backend JavaScript (mootools required for modal.js only)
		$document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/mootools-core.js');
		$document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/mootools-more.js');
		$document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/admin/bootstrap.bundle.min.js');
		$document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/modal.js');
		$document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/jquery-ui.min.js');
		$document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/admin/jquery.form.js');
	    $document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/admin/tadmin.js');
	    $document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/admin/bootstrap-multiselect.js');
	    $document->addScript(JURI::root(1) . '/media/templates/site/sparky_framework/js/admin/jquery.visible.js');
	
		$lang = JFactory::getLanguage();
		$lpreff= $lang->getTag();
		
		$OUT= '';
		ob_start();

		$document->addScriptDeclaration('
			$ = jQuery;
			var TADMSCRIPTTRANS = {};
			TADMSCRIPTTRANS.general    = "' . jText::sprintf('TPL_SPARKY_FRAMEWORK_GENERAL') . '";
			var TADMIN_JOOMLABASE      = "' . JURI::root(1) . '";
			var TADMIN_TEMPLATE_FOLDER = "' . $TEMPLATE_FOLDER . '";
			var TADMIN_LANG = {
				details: "' . JText::sprintf("TPL_SPARKY_FRAMEWORK_DETAILS") . '",
				menusassignment: "' . JText::sprintf("TPL_SPARKY_FRAMEWORK_ASIGNMENT") . '"
		  	};
		  	var sparkycolor1 = "' . $tparams->sparkycolor1 . '";
			var sparkycolor2 = "' . $tparams->sparkycolor2 . '";
			var sparkycolor3 = "' . $tparams->sparkycolor3 . '";
			var sparkycolor4 = "' . $tparams->sparkycolor4 . '";
			var sparkycolor5 = "' . $tparams->sparkycolor5 . '";
			var sparkycolor6 = "' . $tparams->sparkycolor6 . '";
		');
		
		$OUT .= ob_get_contents();
		ob_end_clean();
		
		$doc = new DOMDocument(); 
        $doc->load('..'.DS.'templates'.DS.$TEMPLATE_FOLDER.DS.'templateDetails.xml');
		
		// put all module positions and sparky elements from XML file (structure is extension/positions/position) into object 

		$XPositions = $doc->getElementsByTagName( "extension" )->item(0);
		$XPositions = $XPositions->getElementsByTagName( "positions" )->item(0);
		$XPositions = $XPositions->getElementsByTagName( "position" );

		global $tadmin_mpos; 
		global $tadmin_menus; 
		$tadmin_mpos = array();
		$tadmin_menus = array();

		$loop = 0;
		foreach($XPositions as $XPosition) {
			$tadmin_mpos[$loop] = $XPosition->nodeValue;
			$loop++;
		}

		// get all menu types from DB into $tadmin_menus array

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName('menutype'));
		$query->from($db->quoteName('#__menu_types'));
		$db->setQuery($query);
		$tadmin_menus = $db->loadColumn();
	   
        return $OUT;
		
	}
}
